# [Report Title: Clear, Descriptive, and Specific]

## Executive Summary

[A concise overview of the entire report, typically 200-400 words. Include:
- The research question or topic
- Key findings or conclusions
- Major themes explored
- Significance of the research

This section should be written LAST, after the full report is complete, as it summarizes all findings.]

## Introduction

[Introduce the topic and provide essential background context. This section should:
- Present the research question or topic clearly
- Explain why this topic is important or relevant
- Provide necessary background for readers unfamiliar with the subject
- Outline the scope and structure of the report
- Preview the major sections or themes

Typical length: 500-1000 words]

## Background and Context

[Provide comprehensive background information necessary for understanding the topic. This may include:
- Historical development or evolution of the topic
- Key definitions and concepts
- Foundational theories or frameworks
- Current state of knowledge or practice
- Relevant stakeholders or actors

Typical length: 1000-2000 words

This section may be divided into subsections as appropriate:
### Subsection 1
### Subsection 2
### Subsection 3]

## [Major Topic/Theme 1]

[First major substantive section exploring a key aspect of the research topic.

Structure each major section with:
- Clear introduction to the topic
- Detailed exploration supported by evidence from sources
- Analysis and interpretation of information
- Connection to the broader research question

Use prose paragraphs with varied sentence length. Avoid bullet points unless explicitly requested.

Include inline citations throughout:
- According to [Source] ([Year]), [finding]...
- Research by [Author/Organization] demonstrates that [claim]...
- As documented in [Source], [information]...

Typical length: 1500-3000 words

Divide into subsections if the topic is complex:
### Subtopic 1.1
### Subtopic 1.2
### Subtopic 1.3]

## [Major Topic/Theme 2]

[Second major substantive section exploring another key aspect.

Follow the same structural principles as the previous major section:
- Comprehensive coverage
- Evidence-based analysis
- Proper citations
- Prose format with paragraph structure

Typical length: 1500-3000 words]

## [Major Topic/Theme 3]

[Additional major sections as needed to comprehensively cover the research topic.

The number of major sections will vary depending on the topic complexity and scope. Most comprehensive reports will have 3-6 major substantive sections.

Each section should be thorough and well-developed, not rushed or superficial.]

## Comparative Analysis and Synthesis

[If the research involves comparing multiple entities, perspectives, or approaches, include a section that:
- Compares and contrasts key findings
- Identifies patterns, trends, or themes across different sources or perspectives
- Synthesizes information into coherent insights
- Highlights agreements and disagreements among sources
- Discusses implications of these comparisons

This section demonstrates critical thinking and goes beyond mere reporting to analysis.

Typical length: 1000-2000 words

This section may not be necessary for all topics—use judgment based on the research question.]

## Implications and Applications

[Discuss the broader significance of the findings:
- What are the practical implications?
- How might this information be applied?
- What are the consequences for different stakeholders?
- What challenges or opportunities does this present?
- How does this relate to broader trends or developments?

This section moves from description to interpretation and significance.

Typical length: 800-1500 words]

## Limitations and Uncertainties

[Acknowledge the boundaries and limitations of the research:
- What questions remain unanswered?
- Where is information scarce or unavailable?
- What are the limitations of the sources used?
- Where do credible sources disagree?
- What assumptions were made in the analysis?

This demonstrates intellectual honesty and critical awareness.

Typical length: 400-800 words]

## Conclusions

[Synthesize the key findings and provide closure:
- Summarize the most important findings
- Return to the original research question
- Highlight the significance of what was learned
- Suggest areas for future research or investigation (if appropriate)
- Provide a coherent final perspective on the topic

Avoid introducing new information in the conclusion—this section synthesizes what has already been presented.

Typical length: 500-1000 words]

## References

[Comprehensive list of all sources cited in the report, in alphabetical order by author/organization.

Format:
Author/Organization. (Year). Title. Retrieved from [Full URL]

Example:

International Energy Agency. (2023). World Energy Outlook 2023. Retrieved from https://www.iea.org/reports/world-energy-outlook-2023

McKinsey & Company. (2023). The Economic Potential of Generative AI. Retrieved from https://www.mckinsey.com/capabilities/mckinsey-digital/our-insights/economic-potential-generative-ai

Smith, J., & Johnson, K. (2022). The Economics of Solar Energy: A Meta-Analysis. Journal of Sustainable Energy, 15(3), 234-256. Retrieved from https://example.com/article

World Health Organization. (2023). Road Traffic Injuries. Retrieved from https://www.who.int/news-room/fact-sheets/detail/road-traffic-injuries

Include ALL sources cited in the report. Every inline citation must have a corresponding entry in this References section.]

---

## Notes on Using This Template

### Adaptation

This template provides a general structure. Adapt it based on:

- **Topic nature**: Technical topics may need different sections than policy topics
- **Research scope**: Narrower topics may need fewer major sections; broader topics may need more
- **User requirements**: If the user specifies a particular structure, follow their guidance
- **Logical flow**: Organize sections in the order that makes most sense for the specific topic

### Section Drafting Process

Following the Deep Research methodology:

1. **Create separate draft files** for each major section (e.g., `draft_introduction.md`, `draft_topic1.md`, etc.)
2. **Write each section completely** before moving to the next
3. **Include citations inline** as you write
4. **Combine all sections** into the final report without reduction or summarization
5. **Write Executive Summary** last, after all other sections are complete

### Length Guidance

The length suggestions are guidelines, not strict limits:

- **Minimum total report length**: Several thousand words (typically 5,000-10,000+ words)
- **Individual sections**: Should be proportional to their importance and complexity
- **Do not artificially inflate**: Length should serve comprehensiveness, not word count targets
- **Do not truncate**: If a topic requires extensive treatment, provide it

### Writing Style Reminders

- **Prose paragraphs**: Default format throughout
- **Varied sentence length**: Mix short, medium, and long sentences
- **Formal tone**: Academic, objective, analytical
- **Third person**: Avoid first person (I, we) and second person (you)
- **Active and passive voice**: Use both as appropriate for clarity
- **Evidence-based**: Every claim supported by citations
- **No emojis**: Unless explicitly requested by user
- **User's language**: Write in the language the user used in their request

### Common Adaptations

**For technical topics**: Add sections on methodology, technical specifications, performance analysis

**For policy topics**: Add sections on stakeholder perspectives, regulatory frameworks, implementation challenges

**For historical topics**: Organize chronologically or thematically as appropriate

**For comparative topics**: Structure around entities being compared, or around dimensions of comparison

**For emerging topics**: Emphasize recent developments, uncertainties, and future implications

The key is to create a comprehensive, well-structured, thoroughly researched document that addresses all aspects of the research question with rigor and clarity.
