# Luhmann Scan 工作流

> 这是本 skill 的核心创新：**边创建边发现**。

---

## 什么是 Luhmann Scan？

每次创建完一张原子笔记后，执行的一套标准化问答：

### 问题 1：前置依赖
> "要完全理解这张卡片，还需要哪些笔记？"

**思考方向**：
- 这张卡片引用了哪些未定义的术语？
- 这张卡片的论证基于哪些更基础的概念？
- 如果读者没读过 X，能看懂这张卡片吗？

### 问题 2：潜在连接
> "这张卡片暗示了哪些相关概念？"

**思考方向**：
- 这个概念在其他领域有没有对应物？
- 有没有"对立面"或"替代方案"？
- 这个概念的应用场景是什么？

### 问题 3：方法论发现
> "这个概念（what）被提及时，是否也交代了可执行的方法论（how）？"

**思考方向**：
- 书中是否给出了步骤、清单、模板或练习方式？
- 若有，创建立即建卡。

---

## Scan 结果处理

发现的潜在笔记按**轮次**分类：

| 轮次 | 定义 | 来源 |
|------|------|------|
| **Round 1** | 显式链接 | 结构笔记/索引笔记中直接提到的 |
| **Round 2** | 隐式依赖 | Round 1 笔记的 Scan 中发现的 |
| **Round 3** | 外围扩展 | Round 2 笔记的 Scan 中发现的 |

---

## 示例

### 输入笔记：[[快乐跑步机效应]]
创建完这张笔记后，执行 Scan：

**问题 1：前置依赖**
- 要理解"快乐跑步机"，需要知道**多巴胺**是什么 → [[多巴胺预测误差]]
- 这个效应是进化产物 → [[自然选择的错觉机制]] (已在 Round 1)

**问题 2：潜在连接**
- 这和经济学的"享乐适应"是同一回事吗？→ [[享乐适应]]
- 有没有打破跑步机的方法？→ [[多巴胺断食]]
- 佛学怎么看这件事？→ [[贪爱]]

**问题 3：方法论发现**
- 书中若给出「打破快乐跑步机」的具体练习（如多巴胺断食步骤）→ [[多巴胺断食_SOP]] (Phase 4 创建)；本例假设无，故无。

**Scan 结果**：
- Round 2: [[多巴胺预测误差]]
- Round 3: [[享乐适应]], [[多巴胺断食]], [[贪爱]]
- 方法论: 无（若有则写 `[[方法名]] (Phase 4)`）

---

## 在 task.md 中记录

每张卡一行 Scan 汇总，格式：

```markdown
- [x] **[[快乐跑步机效应]]** (Mechanism)
    - *Luhmann Scan*: 前置 → Round 2: [[多巴胺预测误差]]. 连接 → Round 3: [[享乐适应]], [[多巴胺断食]], [[贪爱]]. 方法论 → (无；若有则写 [[方法名]] Phase 4)
```

---

## 何时停止？

1. **用户明确停止**
2. **新发现的笔记已超出本书范围**（如关联到完全不同的学科）
3. **边际收益递减**：Round 3+ 的笔记对理解本书帮助有限

> 记住：目标是**理解这本书**，不是建一个百科全书。
