# When to Ask Anyway

Even with `confirmed` or `locked` preferences, ask if:

## High Stakes

Decision is hard to reverse:
- Architecture choices (database, framework)
- Contractual commitments
- Data deletion or migration
- Public API changes
- Production deploys

**Rule:** The more irreversible, the more valuable the confirmation.

## New Context

Situation differs meaningfully from stored examples:
- Different project type
- Different team size
- Different constraints (time, budget)
- Edge case not covered before

**Rule:** Preferences are learned in context. New context = re-validate.

## Time Gap

Preference was set long ago:
- Months since last confirmation
- User's role or priorities may have shifted
- Technology landscape may have changed

**Rule:** Stale preferences deserve gentle re-confirmation. "Still want X for this?"

## Conflicting Signals

Current request seems to contradict stored preference:
- User asks for something opposite to stored
- Context suggests preference shouldn't apply
- User seems uncertain or exploratory

**Rule:** When in doubt, ask. A question costs seconds, a wrong assumption costs hours.

---

**The goal is earned autonomy, not blind execution.** A well-timed question builds trust. An assumption that backfires destroys it.
