# Examples for Debugging R Environment and Dependencies

This directory contains example scenarios that demonstrate how the skill diagnoses and fixes R environment issues.

## Demo Scenarios

Each demo project represents a common R environment problem with a broken setup that needs to be diagnosed and fixed.

### Package Installation Failures

Projects that demonstrate:
- Missing system dependencies (e.g., `sf`, `xml2`, `curl`)
- Compilation failures
- Repository configuration issues

### Dependency Conflicts

Projects that demonstrate:
- Version mismatches between packages
- Incompatible package combinations
- Broken renv environments

### Bioconductor Issues

Projects that demonstrate:
- Bioconductor version mismatch with R version
- BiocManager installation problems
- Bioinformatics package dependencies

---

## Usage

Navigate to any demo project directory and invoke the skill to see how it diagnoses and fixes the environment issues.
