---
name: ddg
description: Use ddgr (DuckDuckGo from the terminal) to perform privacy-focused web searches from the command line. Use when the user wants to (1) Search the web from the terminal, (2) Perform DuckDuckGo searches without opening a browser, (3) Get quick search results in text format, (4) Search privately without tracking, (5) Use DuckDuckGo bangs (!) from terminal.
---

# ddgr - DuckDuckGo from the Terminal

**ddgr** is a command-line utility to search DuckDuckGo from the terminal. It provides fast, privacy-focused web searches without opening a browser.

## Installation

### Via Snap (recommended for Ubuntu):
```bash
sudo snap install ddgr
```

### Via PPA:
```bash
sudo add-apt-repository ppa:twodopeshaggy/jarun
sudo apt-get update
sudo apt-get install ddgr
```

### From source:
```bash
git clone https://github.com/jarun/ddgr.git
cd ddgr
sudo make install
```

**Dependencies:** Python 3.8 or later

## Basic Usage

### Simple search (non-interactive):
```bash
snap run ddgr "search query" --np
```

### Search with specific number of results:
```bash
snap run ddgr "search query" --num 5 --np
```

### Search with time limit:
```bash
snap run ddgr "query" --time w --np    # past week
snap run ddgr "query" --time m --np    # past month
snap run ddgr "query" --time y --np    # past year
```

### Site-specific search:
```bash
snap run ddgr "query" --site github.com --np
```

### JSON output:
```bash
snap run ddgr "query" --json --np
```

### Open first result in browser:
```bash
snap run ddgr "query" --ducky
```

## Interactive Mode

Run without `--np` to enter interactive mode:
```bash
snap run ddgr "search query"
```

**Interactive commands:**
- `1`, `2`, `3`... → open result in browser
- `n` → next page of results
- `p` → previous page of results
- `q` or `Ctrl+D` → quit
- `?` → show help

## Advanced Options

| Option | Description |
|--------|-------------|
| `-n N`, `--num N` | Show N results per page (0-25, default 10) |
| `-r REG`, `--reg REG` | Region-specific search (e.g., 'us-en', 'uk-en') |
| `-t SPAN`, `--time SPAN` | Time limit: d (day), w (week), m (month), y (year) |
| `-w SITE`, `--site SITE` | Search specific site |
| `-x`, `--expand` | Show complete URLs |
| `--json` | Output in JSON format |
| `--ducky` | Open first result in browser |
| `--np`, `--noprompt` | Non-interactive mode |
| `--unsafe` | Disable safe search |

## DuckDuckGo Bangs

Use DuckDuckGo bangs to search specific sites:
```bash
snap run ddgr "!w Linux" --np        # Wikipedia search
snap run ddgr "!yt music" --np       # YouTube search
snap run ddgr "!gh python" --np      # GitHub search
snap run ddgr "!a books" --np        # Amazon search
```

## Make it Easier with an Alias

Add to `~/.bashrc` or `~/.zshrc`:
```bash
alias ddg='snap run ddgr'
```

Then use:
```bash
ddg "search query" --np
```

## Privacy Features

- No user tracking or profiling
- Do Not Track enabled by default
- Works over Tor network (with proxy)
- HTTPS proxy support
- No stored search history

## Examples

### Search for tech news:
```bash
snap run ddgr "latest AI news 2025" --num 5 --np
```

### Find Ubuntu tutorials:
```bash
snap run ddgr "Ubuntu tutorial" --site askubuntu.com --np
```

### Search recent Python documentation:
```bash
snap run ddgr "Python 3.12 features" --time m --np
```

### Use bang to search Wikipedia:
```bash
snap run ddgr "!w OpenClaw" --np
```

## Troubleshooting

**Command not found:**
- Ensure ddgr is installed via snap: `sudo snap install ddgr`
- Use full command: `snap run ddgr` instead of just `ddgr`

**No results:**
- Check internet connection
- Try without `--np` to see if interactive mode works
- Verify DuckDuckGo is accessible in your region

**Slow response:**
- DuckDuckGo HTML interface can be slower than main site
- Use `--time` to limit results by time for faster queries

## More Information

- GitHub: https://github.com/jarun/ddgr
- DuckDuckGo: https://duckduckgo.com
- Bangs: https://duckduckgo.com/bang
