---
name: ddg-search
description: DuckDuckGo HTML search scraper CLI with JSON, CSV, OpenSearch, markdown, and compact outputs.
homepage: https://github.com/camohiddendj/ddg-search
metadata:
  {
    "openclaw":
      {
        "emoji": "🦆",
        "requires": { "bins": ["ddg-search"] },
        "install":
          [
            {
              "id": "node",
              "kind": "node",
              "package": "ddg-search",
              "bins": ["ddg-search"],
              "label": "Install ddg-search CLI (npm)",
            },
          ],
      },
  }
---

# ddg-search

Search DuckDuckGo from the command line. Results go to stdout; progress goes to stderr.

## Quick reference

```bash
ddg-search "query"                          # default: JSON, 5 pages
ddg-search -f compact "query"               # minimal-token output (best for LLM context)
ddg-search -f jsonl "query"                 # one JSON object per line
ddg-search -n 10 "query"                    # stop after 10 results
ddg-search -p 2 -f json "query"             # 2 pages, JSON
ddg-search -r us-en -t w "recent topic"     # US-English, past week
ddg-search -p 0 "query"                     # unlimited pages (scrape all)
```

## Options

| Flag | Long | Description | Default |
|------|------|-------------|---------|
| `-f` | `--format` | Output format: `json`, `jsonl`, `csv`, `opensearch`, `markdown`, `compact` | `json` |
| `-p` | `--pages` | Max pages to scrape (0 = unlimited) | `5` |
| `-n` | `--max-results` | Stop after this many results | all |
| `-r` | `--region` | Region code (e.g. `us-en`, `uk-en`) | all regions |
| `-t` | `--time` | Time filter: `d` (day), `w` (week), `m` (month), `y` (year) | none |

## Choosing a format

- **`compact`**: Use for feeding results into an LLM. Minimal tokens, no JSON overhead.
- **`jsonl`**: Use when piping to line-oriented tools or streaming processors.
- **`json`**: Use when you need structured data with OpenSearch metadata, zero-click answers, and spelling corrections. Pipe through `jq` for field extraction (e.g. `| jq '.items[].link'`).
- **`csv`**: Use for spreadsheets or tabular analysis.
- **`markdown`**: Use for human-readable output or embedding in documents.
- **`opensearch`**: Use when producing Atom XML feeds.

## Extracting URLs from JSON output

```bash
ddg-search "query" | jq -r '.items[].link'
```

## Notes

- DuckDuckGo may trigger bot detection. The tool stops early and returns whatever results were collected.
- Random delays (800–2900 ms) are inserted between page fetches automatically.
- Progress messages appear on stderr, so redirecting stdout captures only results.
