# ddgr - Common Usage Patterns

## Quick Reference

### Basic Search Patterns

```bash
# Simple search
ddgr "python tutorial" --np

# More results
ddgr "python tutorial" --num 20 --np

# JSON output for scripting
ddgr "python tutorial" --json --np
```

### Time-Based Searches

```bash
# Last 24 hours
ddgr "breaking news" --time d --np

# Past week
ddgr "tech updates" --time w --np

# Past month
ddgr "product reviews" --time m --np

# Past year
ddgr "best of 2024" --time y --np
```

### Site-Specific Searches

```bash
# Search GitHub
ddgr "machine learning" --site github.com --np

# Search Stack Overflow
ddgr "python error" --site stackoverflow.com --np

# Search Reddit
ddgr "linux tips" --site reddit.com --np

# Search documentation
ddgr "API reference" --site docs.python.org --np
```

### Popular DuckDuckGo Bangs

```bash
# Wikipedia
!w Linux

# YouTube
!yt tutorial

# GitHub
!gh repository

# Amazon
!a product

# Google Maps
!maps location

# Weather
!weather city

# Dictionary
!define word

# Translate
!translate text

# Currency converter
!convert 100 USD to EUR

# Calculator
!calc 2+2
```

### Region-Specific Searches

```bash
# US results
ddgr "news" --reg us-en --np

# UK results
ddgr "news" --reg uk-en --np

# German results
ddgr "news" --reg de-de --np

# French results
ddgr "news" --reg fr-fr --np
```

### Integration with Other Tools

```bash
# Pipe to less
ddgr "long query" --np | less

# Save to file
ddgr "research topic" --np > results.txt

# Extract URLs only
ddgr "query" --np | grep -oP 'https?://[^\s]+'

# JSON processing
ddgr "query" --json --np | jq '.[] | .title'

# Count results
ddgr "query" --np | wc -l
```

### Advanced Filtering

```bash
# Exact phrase
ddgr '"exact phrase"' --np

# Exclude terms
ddgr "python -snake" --np

# File type search
ddgr "filetype:pdf tutorial" --np

# Unsafe search (disable safe search)
ddgr "query" --unsafe --np
```

## Use Cases

### 1. Development Research
```bash
# Find code examples
ddgr "python requests example" --site github.com --np

# Check documentation
ddgr "function reference" --site docs.python.org --np

# Find solutions to errors
ddgr "error message" --site stackoverflow.com --time m --np
```

### 2. News and Updates
```bash
# Latest tech news
ddgr "tech news" --time d --num 10 --np

# Product announcements
ddgr "product launch" --time w --np

# Security updates
ddgr "security vulnerability" --time d --np
```

### 3. Learning Resources
```bash
# Find tutorials
ddgr "beginner tutorial" --site youtube.com --np

# Documentation
ddgr "getting started guide" --site docs.readthedocs.io --np

# Courses
ddgr "online course" --time y --np
```

### 4. Quick Facts
```bash
# Wikipedia lookup
!w topic

# Weather
!weather London

# Definitions
!define serendipity

# Conversions
!convert 5 feet to meters
```

## Tips and Tricks

1. **Use --np for scripting**: The `--np` (no prompt) flag is essential when using ddgr in scripts or piping output.

2. **Combine with other tools**: ddgr works great with grep, awk, sed, and other text processing tools.

3. **Save common searches**: Create shell functions for frequently used searches:
   ```bash
   ddg-code() { ddgr "$1" --site github.com --np; }
   ddg-so() { ddgr "$1" --site stackoverflow.com --np; }
   ```

4. **Use JSON for structured data**: When you need to process search results programmatically, use `--json`.

5. **Bang shortcuts**: Learn common DuckDuckGo bangs for faster searches to specific sites.

## Limitations

- Maximum 25 results per page
- HTML version of DuckDuckGo (not all features available)
- No image or video search
- No autocomplete suggestions

## Comparison with Web Search

| Feature | ddgr | Browser |
|---------|------|---------|
| Speed | Fast | Depends on connection |
| Privacy | High | Lower |
| Images | No | Yes |
| JavaScript | No | Yes |
| Scriptable | Yes | Limited |
| Bangs | Yes | Yes |
