# 全场悬疑方法论

> 摘自《好课像大片》第七章，供各阶段技能引用。

---

## 核心理念

**悬疑的定义**：
- **疑** = 设疑（老师主动提出疑问）
- **悬** = 悬念（学员对答案怀有急迫期待）

**悬疑的三大作用**：
1. **制造注意力**：解决学员"坐得住、听得住、跟得住"的挑战
2. **制造思考力**：深度思考让学员对课程产生浓厚兴趣
3. **制造说服力**：引导学员自己说出答案，实现自我说服

---

## 全场悬疑两大标准

### 标准一：从头问到尾

**障碍1：不敢问**
- 克服心理障碍：讲师拥有话语权，是场上主人
- 提问后无人回答，尴尬的是学员而非讲师
- 学会与学员比耐心

**障碍2：不会问**
- 避免让学员困惑的问题（与主题无关）
- 避免封闭式问题（只能回答是/否）
- 问题需要精心设计和准备

### 标准二：从头应到尾

**互动能力**：
- 提问、互动、答案都需要精心策划
- 每次互动像一场战争，不打无准备之仗
- 答案要简洁明了（如"好课就是换脑"）

**控场能力**：
- 迅速点燃现场氛围
- 精准辨别积极学员和冷眼旁观者
- 用目光鼓励积极学员，让星星之火蔓延
- 确保学员在互动中感受到收获和价值

---

## 避免"成功学式互动"

**禁止行为清单**：
- 不断催促"此处应有掌声"
- 频繁说"听懂了吗？掌声！"
- 要求举手且手势要高且直
- 要求说"yes"配合手势
- 强行推销
- 频繁询问"是不是、好不好、对不对"
- 讲话时频繁播放激情音乐
- 过于夸张地鼓掌
- 上台有保镖陪同

**避免"段子手式互动"**：不要把唱歌、讲笑话当作互动手段

---

## 悬疑式互动方法论

**核心三句话**：
1. **一切问当先**：互动始终从提问开始，避免过早抛出观点
2. **用问解万难**：用提问调动学员、控场、应对突发事件
3. **先问后总结**：学员充分分享后，讲师总结并提出观点

---

## 全场悬疑方法论（三大动作）

### 动作一：悬疑提问（8个标准化问题）

每节90分钟课程由8个问题构成（约每10分钟一个问题）：

| 序号 | 问题 | 阶段 |
|------|------|------|
| 1 | 我们这节课要解决什么问题？ | 定义问题 |
| 2 | 这个问题对学员来说是否重要？ | 定义问题 |
| 3 | 在解决这个问题时，我们面临的卡点在哪里？ | 定义问题 |
| 4 | 为什么我们始终无法有效解决这个问题？ | 分析问题 |
| 5 | 如果维持现状不解决，会带来什么后果？ | 分析问题 |
| 6 | 解决这个问题的思路是什么？ | 分析问题 |
| 7 | 按照这样的思路解决问题，对学员有什么好处？ | 分析问题 |
| 8 | 具体的解决方案或操作步骤是什么？ | 解决问题 |

### 动作二：悬疑互动

**方式1：直接互动**

三种对象：
- 全班互动：面向所有学员
- 小组互动：定向抛给特定小组
- 个人互动：针对特定学员

**技巧**：
- 重复提问（可重复三次以上）
- 保持镇定（沉默给学员压力）
- 展现自信（敢于眼神交流）
- 善于引导（"还有吗？""再想想看"）
- 避免与学员抢答
- 礼貌打断过长发言

**应对挑战：转移焦点策略**
- A：转移到提问学员身上（反问其目的）
- B：转移到其他学员身上（让更多人发表观点）
- C：转移到课后（约定课后深入交流）

**方式2：PK互动**
1. 分小组（每组6-10人）
2. 建组织（选组长、发言人、定口号）
3. 定规则（积分制）
4. 设奖励（讲师著作或小礼品）

### 动作三：悬疑反转

**三个动作**：
1. **总结**：归纳学员的各种回答
2. **反转**：抛出高度概括、简洁、引发共鸣的答案
3. **AB搭档分享**：学员将内容转化为自己的理解（"扎口袋"）

**反转要求**：
- 答案必须得到学员高度认同
- 符合学员期待但思考深度超越他们
- 切忌拖沓，答案需精心设计
- 示例："什么是好课？好课就是换脑。"
