# 阶段六：课程销售（说销）

课程设计第六阶段。帮助设计"不销而销"的课程销售策略。

---

## 核心理念

### 大片营销 vs 疯狂推销

课程销售应该像大片营销一样，让学员主动想要购买，而非强行推销。

| 维度 | 大片营销 | 疯狂推销 |
|------|----------|----------|
| 方式 | 通过价值吸引 | 通过话术逼单 |
| 效果 | 学员主动购买 | 短期成交但伤害信任 |
| 对讲师形象 | 增强专家权威 | 损害威信和专家形象 |
| 长期价值 | 高转介绍率和续单率 | 一次性交易 |

### 不销而销

**核心观点**：讲师不应疯狂推销、过度承诺或过度广告。这种销售理念不适合讲师这一特殊身份。无论推销技巧多么高超，直接向学员推销课程都会损害讲师的威信和专家形象。虽然可能会成交几个学员，但同时可能会伤害更多学员。

---

## 钉子营销

### 钉子营销的由来

作者原本计划撰写第8章"好课销售"，探讨如何将一堂商业课程销售额提升至亿元级。这一章将总结多年成功实践经验，介绍一套课程销售的方法论：**钉子营销**。

顾名思义，这套方法论教讲师如何在课程中"打钉子"，实现不销而销。

### 钉子营销三步法

通过以下三个步骤实现不销而销：

1. **定义价值**：明确课程的核心价值主张
   - 明确课程解决什么问题
   - 量化课程带来的价值
   - 用学员能理解的语言表达价值
   - 对应课程开场：挖掘需求

2. **承诺价值**：在课程中兑现价值承诺
   - 通过课程内容兑现承诺
   - 用案例和成果证明价值
   - 让学员亲身体验价值
   - 对应课程中场：让学员做出选择

3. **传播价值**：让学员成为价值的传播者
   - 让学员成为传播者
   - 通过口碑实现裂变
   - 好框架 = 100 个销售员
   - 对应课程收场：临门一脚

这三个步骤实际上也是现代营销的本质。作为市场经济的一部分，商业课程应回归商业本质。

---

## 课程天生具备营销思维

### 核心观点

将课程聚焦于解决问题，就是让课程天生具备营销思维。从大片课程的结构来看，整个过程就是在进行营销，潜移默化地聚焦于客户价值。

### 解决问题三部曲与营销对应

| 步骤 | 课程内容 | 课程位置 | 营销对应 |
|------|----------|----------|----------|
| **定义问题** | 找到痛点 | 开场 | 挖掘需求 |
| **分析问题** | 分析现状（错点）和标杆（盲点） | 中场 | 让学员做出选择 |
| **解决问题** | 剖析要点 | 收场 | 临门一脚 |

### 详细对应关系

**定义问题 = 挖掘需求**：
- 课程开场就需要塑造挑战
- 只有塑造挑战才能让学员决心改命
- 从一开始就挖掘学员的需求

**分析问题 = 让学员做出选择**：
- 课程中场挑战现状
- 要推翻现状，然后成为现状
- 让学员做出选择，选择你而不是竞争对手

**解决问题 = 临门一脚**：
- 课程结束时要确保学员理解要点
- 将其落到实处，促使学员行动
- 最后的临门一脚

---

## 框架作为销售核武器

### 一个好框架 = 100 个销售员

无论是讲师还是企培机构，始终面临两个选择：
- 要么依赖大量的销售员去说服
- 要么依赖出色的框架去说服

### 框架的三重销售价值

**销售武器**：
- 用框架赢得客户信任，通过讲解框架促成销售
- 当客户对框架产生兴趣时，会邀请销售伙伴进一步介绍
- 销售伙伴详细介绍框架后，客户往往会决定购买

**传播武器**：
- 学员深入理解后自发分享
- 口碑传播是最有效的营销

**训练武器**：
- 利用框架培训新员工、考核、PK
- 销售伙伴在拜访客户时，只需带上课程大纲，简单讲解一遍即可

### 实操经验

在行动教育的实践：
- 把课程大纲视为核武器
- 销售伙伴去企业时主要工作就是分享大纲
- 大纲不仅仅是大纲，它更是传递信任的桥梁
- 业绩不佳时不应归咎于销售员，而应反思课程质量
- 销售方面的问题并非讲师应关注的重点，课程的打磨首先从框架的优化开始

---

## 解决问题三种思维

### 问题思维

- 焦点集中在问题上，而非解决方案
- 避免思维定式和路径依赖
- 客户关注的是"你究竟解决了什么问题"
- 讲师自己想讲的内容永远不如客户关心的问题重要
- 始终确保自己正在解决的是客户非常关注的问题

### 终点思维

- 不仅要关注问题，还要以问题来重塑解决方案
- 找到问题并不意味着结束，还需要重塑解决方案
- 原有的解决方案可能与终点问题不匹配、不聚焦、不清晰、不深入
- 先有问题，再有解决方案
- 跳出原有的解决方案，避免惯性思维

### 本质思维

- 取一舍九，抓住核心，一招制敌
- 避免"是什么、为什么、怎么做"的知识灌输模式
- 聚焦领域最核心的一个问题
- 很多讲师掌握了多种技能，创造了很多出色的模型，但关键在于抓住问题的核心

---

## 说销 6 步

### 1. 方法论总结

- 回顾课程核心方法论
- 用一句话概括课程价值
- 强化钉子印象
- 让学员能用一句话向别人介绍这门课

### 2. 案例见证/成果展示

- 展示学员/客户的实际成果
- 用数据说话
- 真实案例比理论更有说服力
- 案例要具体、可验证

### 3. 传递感受（催人泪下的小故事）

- 讲自己的故事（讲我所做，做我所讲）
- 传递使命感和情感
- 让学员感受到你的真诚
- 感受比道理更能打动人

### 4. 使命感召

- 传递课程背后的使命
- 激发学员的使命感
- 让学员感受到参与的意义
- "每个人的一生中都应该有两个工程：一本书和一堂大片课"

### 5. 产品亮剑

- 清晰展示产品/课程体系
- 突出核心价值和差异化
- 简洁有力，不啰嗦
- 让学员清楚知道下一步可以做什么

### 6. 客户见证

- 真实客户的反馈和推荐
- 学员的转变故事
- 社会证明
- 让潜在学员看到"和我类似的人已经成功了"

---

## 语言共情技巧

说销阶段需要融入语言共情，通过感叹、感性、感动三种方式增强表达力。

### 1. 语言要感叹：短句、排比、押韵

- 短句比长句更有力量，更能传递感受
- 长句应压缩或拆分为多个短句
- 配合排比和押韵增强效果

**示例对比**：
- 长句："什么是好的商业课程？好的商业课程就是给予学员新的认知、观点和方法，并把新的观点和方法应用到学员工作中去，从而提升学员的工作效率。"
- 短句："什么是好课？好课就是换脑！换的是'新'，新认知、新观点、新方法。换的是'更'，更好的、更高效率的。换的是'代'，清除旧认知、旧观点。"

### 2. 语言要感性：通过类比使理性语言富有情感

- 经典案例：乔布斯对斯考利说"你是想卖一辈子糖水，还是和我一起改变整个世界？"
- 感性语言能深入潜意识，引发共鸣

### 3. 语言要感动：细节和画面感

- 感动源自具体细节和画面感
- 避免泛泛而谈，要"说人话"、贴近实际
- 案例：刘强东"跑步鸡"演讲（鸡脚戴计步器、走100万步、6-8个月、120元回购）

---

## 销售自检清单

- [ ] 是大片营销而非疯狂推销？
- [ ] 是否损害讲师威信和专家形象？
- [ ] 学员是否主动想要购买？
- [ ] 课程本身是否天生具备营销思维？
- [ ] 框架是否能作为销售核武器？
- [ ] 是否有真实的案例见证和客户反馈？
- [ ] 是否传递了使命感而非功利心？
