# 阶段四：课程中场（说服）

课程设计第四阶段。帮助设计"挑战现状"的课程内容。

---

## 核心公式

**好中场 = 挑战现状**

### 什么是现状

- 旧有的认知、观点、底层逻辑和方法论
- 习惯、客观存在及普遍事实
- 深入人心，为人所依赖

**核心观点：沿着旧地图，找不到新大陆**

### 现状的本质

- 现状就是错误，就是顽疾
- 是一切目标与问题的根源、症结、起点与主要矛盾
- 是目标的绊脚石，是问题的核心所在

### 不破不立，大破大立

- 与主流观点产生冲突，底层逻辑与现状存在对立，才是真正的挑战现状
- 只有颠覆旧认知，才能建立新认知
- 比现状更好不是挑战现状：只要底层逻辑未变，再多改善也只是"人云亦云"

### 挑战现状的优势

**比挖掘痛苦更有说服力**：
- 没有坏人，哪有好人；坏人足够坏，才彰显好人足够好
- 好坏是通过对比得出的
- 有对比才更有说服力

**更符合人性**：
- 人们天生喜欢对抗
- 喜欢挑战强者
- 喜欢看热闹
- 对抗能凝聚人心，激发同仇敌忾的情绪

### 关键区分

- **冲突对立** 才能挑战现状
- **比现状更好** 不是挑战现状
- 只要底层逻辑未变，再多改善也只是"人云亦云"

---

## 核心逻辑：先破后立

### 第一步：锁定现状

**定义现状**：
- 现状必须具体且可清晰定义
- 两种类型：习惯型（长期形成的做法）或深入人心型（普遍认同的观点）
- 绝非废话、空话、无谓之谈或笑话
- 不是正话反说

**诠释现状**：
- 解释应简明扼要
- 如果解释复杂，说明定义存在问题，可能不够清晰
- 例如：纪录片就是将主题划分为多个模块，然后分别解释和论证

**案例说明**：
- 用具体案例帮助理解
- 案例要贴近学员实际
- 让学员产生"对，我就是这样做的"的共鸣

### 第二步：打倒现状

**后果**：
- 现状不仅无法解决核心问题，还可能引发新问题
- 让学员看到维持现状的代价

**原因**：
- 回答"为什么"现状无法解决核心问题
- 不超过三个原因
- 每个原因要有说服力

**除非**：
- 环境变化导致以前可以现在不行
- 时代变了，规则变了
- 增加紧迫感

### 第三步：成为现状

**定义新方法**：
- 命名应与现状形成鲜明对比
- 例如：纪录片 vs 大片

**诠释新方法**：
- 解释简洁明了
- 与现状解释形成对立

**案例对比**：
- 使用与解释现状相同的案例进行对比
- 同一个案例，两种做法，效果天壤之别

**阐述好处**：
- 与核心问题的解决紧密相关
- 不是泛泛的好处，而是直接解决痛点

**分析原因**：
- 回答为什么新方法能解决核心问题
- 不超过三个原因
- 逻辑清晰，有说服力

---

## 挑战现状三标准

| 标准 | 要求 | 常见挑战 |
|------|------|----------|
| **有现状** | 具体的、明确的、可以清晰定义的 | 讲师自己就是现状的一部分；找不到现状 |
| **强现状** | 代表90%的真实面貌，普遍存在 | 所罗列的现状并非共性；对现状研究不够 |
| **有对抗** | 新旧底层逻辑之间的激烈碰撞 | 要过自己的心坎；要过学员的心坎 |

### 有现状

- 现状应该是具体的、明确的、可以清晰定义的
- 现状就是起点，没有起点就没有终点
- 新观点找不到起点，就是凭空出现，无法立足

**两大挑战**：
- 讲师自己就是现状的一部分（讲授内容是陈词滥调）
- 找不到现状（研究不够深入或在解决假问题）

### 强现状

- 现状必须代表90%的真实面貌
- 必须是普遍存在并成为习惯的
- 没有强大的旧认知，就不可能有伟大的新认知

**两大挑战**：
- 讲师所罗列的现状并非共性，缺乏代表性
- 很多讲师对"现状"的研究不够重视

### 有对抗

- 新旧底层逻辑之间的激烈碰撞
- 一场你死我活的较量
- 只有打破旧有的，才能建立新的（大破大立）

**两大挑战**：
- 讲师要过自己的心坎（对旧观点有情感纽带）
- 讲师要过学员的心坎（旧认知已成习惯）

---

## 人云亦云的问题

### 问题表现

仅仅以主流观点去攻击旧习惯、旧做法。

### 后果

挑战现状时没有感觉，缺乏冲击力。

### 解决方法

必须找到与主流观点不同的底层逻辑，形成真正的冲突对立。

---

## 融入的悬疑技巧：悬疑8问

每个模块（约90分钟）由8个标准化问题驱动（约每10分钟一个问题）：

| 序号 | 问题 | 阶段 |
|------|------|------|
| 1 | 我们这节课要解决什么问题？ | 定义问题 |
| 2 | 这个问题对学员来说是否重要？ | 定义问题 |
| 3 | 在解决这个问题时，我们面临的卡点在哪里？ | 定义问题 |
| 4 | 为什么我们始终无法有效解决这个问题？ | 分析问题 |
| 5 | 如果维持现状不解决，会带来什么后果？ | 分析问题 |
| 6 | 解决这个问题的思路是什么？ | 分析问题 |
| 7 | 按照这样的思路解决问题，对学员有什么好处？ | 分析问题 |
| 8 | 具体的解决方案或操作步骤是什么？ | 解决问题 |

---

## 案例参考

### 大片课自身的中场设计

| 现状 | 新方法 |
|------|--------|
| 纪录片授课（将主题细分为模块详细解释） | 大片授课（将知识点转化为挑战与解决方案） |
| 差异化战略（确定目标市场、产品差异化和销售策略） | 钉子定位（一招+一痛+一不） |

### 行动教育案例

- 将高校商学院定义为"理论派"（现状）
- 强调实战实效（新方法）
- 重新定义EMBA课程规则

### 特劳特案例

- 将麦肯锡定义为"标杆战略"（现状）
- 提出"心智注册"（新方法）
- 成功将特劳特从广告公司提升为高端战略咨询
