# 阶段二：课程框架（说清）

课程设计第二阶段。帮助构建传递信任的课程框架。

---

## 框架的本质

**框架 = 传递信任**

- 框架是讲师专业功底的镜子
- 框架是治学态度的体现
- 框架是感召学员的武器

**核心观点：一个好框架 = 100 个销售员**

### 框架的三重武器价值

1. **销售武器**：用框架赢得客户信任，促成销售
2. **传播武器**：学员深入理解后自发分享
3. **训练武器**：培训新员工、考核、PK

---

## 框架作为销售核武器

### 底层逻辑

无论是讲师还是企培机构，始终面临两个选择：
- 要么依赖大量的销售员去说服
- 要么依赖出色的框架去说服

### 实操经验

在行动教育的实践：把课程大纲视为核武器，销售伙伴去企业时主要工作就是分享大纲。大纲不仅仅是大纲，它更是传递信任的桥梁。

### 框架先感动自己

框架是讲师用来感召学员的重要工具。讲师首先要做的便是先感动自己，进而感动销售伙伴，再感动合作伙伴。如果连自己都无法感动，又怎能感动学员？

---

## 一剑封喉方法论

### 核心理念

始终坚守一个核心原则，将一招发挥到极致，直至击穿其核心。

### 两大核心动作

1. **取一舍九**：抓主要矛盾，直击问题核心（"抓七寸"），集中力量于最关键的一招
2. **力出一孔**：围绕核心矛盾展开时，进一步聚焦核心要点，精准把握"牛鼻子"

### 应用示例

"换脑大片课"的一招就是"大片"。因此将大片的各个方面都锤炼到极致，确保定位、框架、开场、中场、收场、共情、悬疑和销售等各个环节都与大片的标准相吻合。

---

## 一首诗词方法论

### 目标

将复杂、枯燥、晦涩难懂的理论与工具，化为美妙动人的诗篇。

### 好框架的三大标准

| 标准 | 内涵 |
|------|------|
| **冲击力** | 体现在高度、深度与简度；用家常话讲述深奥道理 |
| **说服力** | 一脉相承、环环相扣、严丝合缝；让听众产生强烈学习欲望 |
| **记忆力** | 押韵、逻辑清晰、内容简单；学员能记住要点 |

---

## 构建框架三步法

### 步骤一：紧盯钉子

- 构建框架的第一步是紧盯钉子（核心观点）
- 展开的是钉子，而非主题
- 每个模块和动作都应紧密围绕钉子展开
- 不断反问：这个模块是否真正支撑课程定位？
- 避免"两层皮"：框架与定位脱节
- 确保整个框架呈现为"一层皮"，实现一脉相承

### 步骤二：取一舍九

- 只打一个点，所有模块为这一招服务
- 抓主要矛盾，直击问题核心
- 力出一孔：围绕核心矛盾展开时，进一步聚焦核心要点

### 步骤三：展开钉子

三大原则：
- **有顺序**：时间关系，内容有明确的先后次序
- **有逻辑**：承上启下，前呼后应
- **有共性**：底层逻辑的一致性

---

## 框架层级要求

- 最多三层，第三层聚焦于具体动作
- 每个模块可视作一节课（约 90 分钟）
- 超过三层逻辑的课程往往过于复杂，效果不佳

---

## 三个极致检验

### 极致一：简单到极致

**三个"一"**：
- **一招**：抓主要矛盾，抓要害，抓本质
- **一秒**：讲大白话，接大地气，一秒就能明白
- **一震**：简单背后不简单，直击人心

**检验方法**：给父母看，讲给他们听。如果父母能理解，说明足够简单。

### 极致二：逻辑到极致

**三个标准**：
- **一脉相承**：整个框架紧密围绕核心底层逻辑展开
- **环环相扣**：模块之间有先后顺序、逻辑关系、共性
- **严丝合缝**：每个模块的关键动作高度一致

**检验方法**：讲给别人听，请对方复述。如果对方能准确复述，说明逻辑清晰。

### 极致三：押韵到极致

- 朗朗上口，押韵工整，节奏感强
- 押韵的文字更有道理，更能触动情感
- 更容易被记住

**案例**：李践"招才选将"的方法论建模——"过五关、斩六将、剩一人"，简洁表达带来巨大力量与高度。

---

## 三大标准检验

### 看一分钟

- 一分钟内入眼入心，赢得信任
- 不要考验人们的耐心
- 框架的视觉呈现必须清晰、简洁

### 听三分钟

- 三分钟内入耳，加深信任
- 三分钟打不动，三小时也难改变
- 口头讲解必须流畅、有逻辑

### 说五分钟

- 学员能在五分钟内清晰表达课程内容
- 实现自动传播
- 这是框架最终的检验标准
