# 阶段一：课程定位（说清）

课程设计第一阶段。帮助找到课程的"钉子"，确保一句话说清课程核心。

---

## 核心公式

**钉子 = 一痛 + 一招 + 一不**

| 要素 | 含义 | 通俗表达 |
|------|------|----------|
| **一痛** | 客户最大痛点 | "你有病" |
| **一招** | 核心解决方案 | "我有药" |
| **一不** | 与竞争对手的最大不同 | "就我有" |

---

## 钉子理论深度解析

### 为什么课程需要"钉子"

课程定位必须浓缩成一个"钉子"，像钉子一样植入学员脑海。

**底层逻辑**：
- 人脑本能抗拒外界输入
- 信息爆炸时代，心智容量有限
- 人脑偏爱简单，排斥复杂
- 只有足够尖锐、足够简单的信息才能穿透心智防线

### "一"的三层含义

- **取一舍九**：找到核心中的核心
- **一箭穿心**：直击学员心灵，尖锐有力
- **一直敲**：不断强调，深深烙印

### 定位 vs 主题

很多讲师混淆"课程主题"和"课程定位"：
- **主题**是通用的（品牌战略、人力资源管理、销售体系），任何讲师都可以用
- **定位**是独特的，包含你的核心观点和差异化
- 主题不是主线，无法串联内容
- 主题不符合"一招、一痛、一不"

### 数字游戏的陷阱

"六脉神剑""天龙八部""五步法"等本质只是数字包装：
- 数字本身不是钉子
- 数字背后的核心观点才是真正的钉子
- 例如"大片换脑"才是钉子，"天龙八部"只是展开方式

---

## 找钉子三条路径

### 路径一：从大痛点出发 → 找一痛

**适用场景**：讲师对客户痛点有深刻理解

**步骤详解**：

1. **定领域**
   - 你深耕哪个领域？
   - 必须是长期深耕的领域，而非临时涉猎

2. **定画像**
   - 目标客户是谁？
   - 建议列出10个具体客户名字
   - 目标客户画像"五有"标准：有背景、有实战、有成果、有团队、有决心

3. **定挑战**
   - 该领域要解决的问题是什么？
   - 能否直接解决？
   - 解决的桥梁是什么？
   - 必须是客户真正关注的焦点，非主观臆想

4. **定观点**
   - 核心解决方案是什么？
   - 核心思想是什么？
   - 有具体案例成果吗？

### 路径二：从大师论出发 → 找一招

**适用场景**：讲师已有成熟的方法论体系

**步骤详解**：

1. 定领域
2. 定画像
3. **定观点**：先明确你的解决方案及其核心思想
4. **定挑战**：再反推解决什么问题，是否有案例成果

**与路径一的区别**：先有解决方案，再找匹配的问题

### 路径三：从大竞争出发 → 找一不

**适用场景**：市场竞争激烈，需要差异化突围

**步骤详解**：

1. 定领域
2. 定画像
3. **定对手**：该领域的主流观点或方法论是什么？
4. **定死穴**：主流观点存在的问题是什么？
5. **定不同**：你和主流观点的不同是什么？

**案例**：
- 特劳特将麦肯锡定义为"标杆战略"进行攻击，成功将特劳特从广告公司提升为高端战略咨询
- 行动教育将高校商学院定义为"理论派"，强调实战实效，重新定义EMBA课程规则

---

## 说清标准详解

### 说清"解决方案"的5个标准

1. **一招制胜**：只有一个核心解决方案
   - 招数太多不仅不能解决问题，反而制造问题
   - "东方不亮西方亮"策略会练成"四不像"

2. **共性贯穿**：所有动作围绕同一共性展开
   - 底层逻辑一致性

3. **底层逻辑支撑**：代表方法论的高度概括
   - 不是技巧集合，而是底层逻辑

4. **与挑战直接高度相关**
   - 解决方案必须直接回应痛点

5. **挑战主流观点**：区别于竞争对手
   - 如果和主流观点一样，就没有存在价值

### 说清"挑战"的7个标准

1. **聚焦一个问题**：痛点分散等于没有痛点
2. **客户关注的焦点**：非主观臆想
3. **振奋人心**：大痛点、大目标
4. **胆识过人**：重新定义行业标准
5. **积极正面的表达**：不是消极抱怨
6. **具体且具备画面感**：能激发鲜明画面
7. **与解决方案直接高度相关**：问题和方案一体

---

## 四好检验标准

| 标准 | 要求 | 自检问题 |
|------|------|----------|
| **好钉子** | 不同一招解决一痛 | 是否找到了一招、一痛、一不？ |
| **好课题** | 课程名称呼应底层逻辑 | 课程名称是否体现核心方法论？ |
| **好广告** | 聚焦学员的期待 | 广告语是否直击学员痛点和渴望？ |
| **好匹配** | 体现讲师专家身份 | 讲师的经历、成果、著作是否支撑定位？ |

### 好钉子
- 核心检验：是否做到"不同一招解决一痛"
- 能否用一句话说清三天课程内容？

### 好课题
- 课程名称是否呼应底层逻辑
- 例如"好课像大片"直接呼应"大片授课"的底层逻辑

### 好广告
- 广告语是否聚焦学员的期待
- 例如"一堂课一个亿"聚焦讲师对商业成功的期待
- 例如"顺势借力，三年五倍，五年十倍"聚焦企业家对增长的期待

### 好匹配
- 讲师的专家身份、经历、成果、著作是否支撑定位
- 没有实践支撑的定位是空中楼阁

---

## 案例库

### 案例一：特劳特定位
- **解决方案（一招）**：心智注册
- **挑战（一痛）**：成为客户首选
- **一不**：区别于传统广告
- **一句话**：在客户心智中注册成为客户首选

### 案例二：高维战略（刘海峰）
- **解决方案（一招）**：顺势借力
- **挑战（一痛）**：改命
- **一不**：区别于传统战略
- **一句话**：顺势借力才能改命
- **广告语**：顺势借力，三年五倍，五年十倍

### 案例三：夏晋宇大片课
- **解决方案（一招）**：把课程做成大片
- **挑战（一痛）**：换脑（深刻改变学员认知）
- **一不**：区别于纪录片授课
- **一句话**：大片换脑
- **广告语**：一堂课一个亿

### 案例四：李践"招才选将"
- **方法论建模**：过五关、斩六将、剩一人
- **特点**：简洁表达带来巨大力量与高度
