# Example: Seneca — On the Shortness of Life

📜 **Lucius Annaeus Seneca — De Brevitate Vitae, 49 AD**

> *"Non exiguum temporis habemus, sed multum perdidimus. Satis longa vita et in maximarum rerum consummationem large data est, si tota bene collocaretur."*
> — De Brevitate Vitae, I.3

🌍 "It is not that we have a short time to live, but that we waste much of it. Life is long enough, and has been given in sufficiently generous measure to accomplish great things — if the whole of it is well invested."

**The Story:** In 49 AD, one of Rome's wealthiest men wrote a letter to his father-in-law Paulinus, who ran the empire's grain supply system — perpetually busy, perpetually stressed. Seneca told him: "People complain life is short, but the problem isn't shortness — it's waste." Then he made his list: people consumed by other people's business, people who say "I'll start tomorrow" forever, people who fill days with endless meetings. His sharpest line targets "busy people": "The busy man is least alive, because he confuses busyness with living." Seneca himself was famously accused of hypocrisy — as Nero's advisor he accumulated enormous wealth, then Nero forced him to commit suicide. But perhaps that's exactly why he described the busyness trap so well: he was writing from inside it.

💡 **Modern Connection:** Two thousand years later, Cal Newport writes "Deep Work" and Tim Ferriss publishes "The 4-Hour Workweek" — both rediscovering what Seneca laid out in a few dozen pages. Slack notifications, infinite Zooms, "always-on" culture — Seneca described all of it in 49 AD, just with different tools. His version: attending unwanted banquets, giving testimony at someone else's trial, listening to gossip at the Forum. And Seneca's bitterest paradox: he wrote this letter while sitting at the center of the busyness trap in Nero's court. Sometimes the best warnings come from inside the trap.

---
_daily wisdom • roman stoicism_
