---
name: daily-trending
description: 获取今日热榜，从tophub.today抓取各平台热搜榜单。当用户询问"今天有什么热搜"、"热榜"、"微博热搜"时触发。
---

# Daily Trending

获取今日热榜，从tophub.today抓取各平台热搜数据。

## 数据获取

### 多平台热榜（必抓）

从tophub.today获取以下平台的热榜：
- 知乎热榜：`/n/mproPpoq6O`
- 微博热搜榜：`/n/KqndgxeLl9`
- 百度实时热点：`/n/Jb0vmloB1G`
- 36氪24小时热榜：`/n/Q1Vd5Ko85R`
- 虎嗅网热文：`/n/5VaobgvAj1`
- 澎湃热榜：`/n/wWmoO5Rd4E`
- 吾爱破解今日热帖：`/n/NKGoRAzel6`
- 虎扑社区步行街热帖：`/n/G47o8weMmN`

### 获取方式

```bash
# 微博热搜
web_fetch("https://tophub.today/n/KqndgxeLl9", maxChars=3000)

# 知乎热榜
web_fetch("https://tophub.today/n/mproPpoq6O", maxChars=3000)

# 百度热点
web_fetch("https://tophub.today/n/Jb0vmloB1G", maxChars=3000)

# 36氪
web_fetch("https://tophub.today/n/Q1Vd5Ko85R", maxChars=3000)

# 虎嗅
web_fetch("https://tophub.today/n/5VaobgvAj1", maxChars=3000)
```

### 筛选标准（关键）

从所有平台的热榜中，筛选出**真正重要的、真正处于讨论焦点的**热点：

1. **重要事件**：重大政策、国际关系、社会事件
2. **热议话题**：引发广泛讨论和争议的话题
3. **真正焦点**：不是明星八卦、广告推广
4. **只讲事实**：排除带主观色彩的评论标题，如"天塌了"、"最惨"、"荒谬"等
5. **事实性内容**：保留事件本身，不加评论渲染

**排除类型**：
- 带主观色彩的评论标题
- 单纯的娱乐八卦
- 明显的广告推广
- 情绪化表达

**保留类型**：
- 事实性事件
- 政策动态
- 社会热议话题
- 真正有讨论价值的焦点

**输出要求**：
- 每条新闻要完整、有头有尾
- 像新闻标题一样描述事件
- 不要单独一个词或没头没尾的内容

## 输出格式

只输出最有价值的5条：

```
---

🔥 今日热榜（2月19日）

1. 高市早苗确认当选日本新任首相，将着手组建新内阁
2. 2026年春节档电影总票房突破20亿元
3. 苏翊鸣夺得米兰冬奥会单板滑雪男子坡面障碍技巧金牌
4. 韩国短道速滑女子3000米接力夺得金牌
5. 沙特投资483亿美元收购字节跳动部分业务

---
```

注意：
- 每条新闻完整、有头有尾
- 不需要来源标注
- 只讲事实，排除主观评论
- 分割线“---”用“======”代替
- 只输出要求输出的内容，前后不要输出多余的文本、说明、报错