---
name: 每日科技播报
description: 从可抓取信息源（新浪科技、IT之家等）拉取当日科技新闻标题，生成简报并输出。无需 API Key，适合定时任务与手动触发。当用户要求执行每日科技播报、科技新闻简报、今日科技要闻时使用此技能。
description_en: "Fetch daily tech headlines from configurable sources (Sina Tech, IT Home). No API Key. Use for cron or when user asks for daily tech broadcast / tech news digest."
metadata:
  clawdbot:
    emoji: "📰"
    requires:
      bins: ["python3.11"]
    primaryEnv: null
---

# 每日科技播报

从**可配置信息源**（新浪科技、IT之家等）抓取当日科技新闻标题，生成简报纯文本。**不依赖任何 API Key**，token 消耗低，适合 OpenClaw cron 定时推送或人工触发。

## 触发条件

当用户提到以下内容时使用此技能：
- 「执行每日科技播报」「今日科技新闻简报」「科技要闻」
- 「每日科技播报」「推一下科技新闻」
- 定时任务消息中明确要求使用「每日科技播报」技能

## 信息源列表（可维护）

脚本内维护的信息源（无需 API Key，直接 HTTP 抓取）：

| 来源     | URL                     | 说明         |
|----------|-------------------------|--------------|
| 新浪科技 | https://tech.sina.com.cn/ | 优先，已验证 |
| IT之家   | https://www.ithome.com/   | 备选         |

可在 `scripts/broadcast.py` 的 `NEWS_SOURCES` 中增删或调整顺序。

## 使用方法

### 推荐 exec 命令（供 cron 或 AI 调用）

```bash
cd <workspace>/skills/daily-tech-broadcast/scripts && python3.11 broadcast.py 2>&1
```

- 简报正文**仅输出到 stdout**，供消息发送；调试信息在 stderr。
- 无需设置环境变量或 API Key。

### 手动执行

```bash
cd <workspace>/skills/daily-tech-broadcast/scripts
python3.11 broadcast.py
```

## 定时任务配置示例

在 OpenClaw cron 中，将每日科技播报任务的 `payload.message` 设为（与第二件事一致）：

```
请使用每日科技播报技能，执行播报并将结果发送到当前频道。使用命令：cd <workspace>/skills/daily-tech-broadcast/scripts && python3.11 broadcast.py 2>&1
```

- 不要使用「搜索今日重要科技新闻」等表述，以免 AI 误用 web_search（需 API Key）。
- 保持 `deliver: true` 及正确的 `channel`、`to`，以便结果投递到目标频道。

## 依赖

仅使用 Python 3 标准库（`urllib`、`html.parser`、`re` 等），无需安装额外包。若需扩展为其他源或解析方式，可参考目录下 `requirements.txt`。

## 故障与降级

- 单源失败时，脚本会继续使用其他源，不会整体失败。
- 若全部抓取失败，会输出一段降级提示文案（仍通过 stdout），便于用户知晓。

---

## English summary

- **What**: Fetch daily tech news headlines from configurable sources (Sina Tech, IT Home), output a digest to stdout. No API Key.
- **When to use**: User says “daily tech broadcast”, “tech news digest”, “今日科技播报”, or cron payload asks for this skill.
- **Run**: `cd <path>/scripts && python3.11 broadcast.py 2>&1`
- **Data sources**: Edit `NEWS_SOURCES` in `scripts/broadcast.py` to add/remove/reorder sources.
