---
name: daily-tang-poem
description: >
  每日唐诗：一句诗 + 讲解，晚上验收，支持艾宾浩斯复习和诗人缘分。触发词：今日唐诗、验收、复习、诗人缘分。
---

# 每日唐诗 📜

每天一句唐诗，白天推送 + 讲解，晚上验收背诵。支持复习（多种题型）和诗人缘分排行。

---

## 一、触发与模式识别

| 用户可能说 | 模式 | 动作 |
|------------|------|------|
| 今日唐诗、早上的诗、今天的诗、daily tang poem | **推送** | 一句诗 + 讲解 |
| 验收、背一下、检查、验收背诵 | **验收** | 背诵一句，你来校验 |
| 复习、抽查、回顾、复习一下 | **复习** | 5 道题，多种题型 |
| 诗人缘分、和谁有缘、哪位诗人、诗人 | **诗人** | 缘分排行 |

**歧义处理**：根据上下文推断。若用户刚收到今日诗再说「背一下」，即验收；若说「复习」则进入复习流程。

---

## 二、推送模式

**流程**：`GET {URL}/?date=YYYY-MM-DD`（不传 date 则用今天）→ 取 `recite_lines[0]` 作为主推送句。

**输出格式**：
1. 标题：《{title}》— {author}（{type}）
2. **主推送**：只展示 `recite_lines[0]` 这一句（若无则用全诗 `contents`）
3. **讲解**：2–3 句，你自己的话。**必须完整展示全诗**（用「全诗：……」引出），不得用省略号或任何方式截断。

**示例**：
```
📜 今日唐诗 · 2025年3月4日

《月下独酌》— 李白（五言古诗）

我歌月徘徊，我舞影零乱。

讲解：李白邀月对饮，与影共舞，把孤独写成热闹。这句从「歌」到「舞」，看似放达实则寂寞。全诗：花间一壶酒，独酌无相亲。举杯邀明月，对影成三人。月既不解饮，影徒随我身。暂伴月将影，行乐须及春。我歌月徘徊，我舞影零乱。醒时同交欢，醉后各分散。永结无情游，相期邈云汉。
```

---

## 三、验收模式

**流程**：
1. 拉取今日诗（同上 API）
2. **提示**：给一个**不透露原句**的提示，如诗歌的亮点、特色、或白话释义（如「今日那句写的是李白月下独酌、与影共舞的意象」），然后请用户背出原句。禁止在提示中出现要背的那句诗本身。
3. 用户输入后，用 `recite_lines_normalized`（或 `contents_normalized`）与用户输入标准化后比对
4. **标准化**：去掉标点、空白、换行
5. **容错**：1–2 字错、常见别字（的/得）可视为通过
6. 通过 →「✅ 背得很好！今日任务完成。」并调用 `POST {URL}/api/pass` 记录（body: `{user_id, date, poem_id}`，user_id 从 `DAILY_TANG_POEM_USER_ID` 读取；若未配置则跳过记录）
7. 未过 → 温和指出，给出正确句，鼓励明天再试

**未看过今日诗**：若用户未先看今日诗就说验收，回复：「今天还没有推送过今日唐诗哦。先对我说「今日唐诗」看看今天是哪一首，晚上再验收吧。」

---

## 四、复习模式

**前置**：复习基于用户**真实验收通过**的句子。验收通过后需调用 `POST {URL}/api/pass` 记录（见下）。用户需配置 `DAILY_TANG_POEM_USER_ID`，可填：终端运行 `uuidgen` 得到的字符串、Telegram chat id、或自定义如 `my-phone`。

**流程**：
1. `GET {URL}/api/review?user_id={DAILY_TANG_POEM_USER_ID}&count=5` → 得到用户已背过的 `items`
2. 若返回 `items` 为空或 `message` 提示无数据，回复用户：「还没有通过验收的句子，先背几天再来复习吧～」
3. 逐题出题、判题、收尾总结。

**记录通过**：用户验收通过时，调用 `POST {URL}/api/pass`，body：`{"user_id": "从 DAILY_TANG_POEM_USER_ID 读取", "date": "当日日期 YYYY-MM-DD", "poem_id": 当日诗 API 返回的 id}`。若未配置 user_id 或 API 返回错误，静默跳过即可。

**题型**（每次混合使用，不必五种全上）：
- **填空**：如「我歌月____，我舞影____。」用户填词，去掉标点后与 `recite_line` 比对
- **默写**：直接背整句，同验收
- **选择题**：给诗句，选作者或诗名；干扰项从 `items` 的 `author`/`title` 中取
- **作者/诗名**：给诗句，问作者或诗名，用户说名字即可
- **排序**：打乱词语让用户排（如「月 我 歌 徘徊」→「我歌月徘徊」），按正确顺序比对

**出题**：一题一题出，答对 ✅ 下一题，答错先给正确答案再下一题。全部结束后：「本轮复习完成，答对 X/5 题。」

**边界**：若返回的 `items` 少于 5 个（如刚开始用），有多少出多少，结尾同样报「答对 X/Y 题」。

**未配置 user_id**：若 API 返回 `user_id required` 或类似错误，提示用户：「复习需要先配置用户 ID。终端运行 `uuidgen` 得到一串字符，在 `~/.openclaw/openclaw.json` 的 `skills.entries["daily-tang-poem"].config` 中添加 `DAILY_TANG_POEM_USER_ID`，重启后再说「复习」。」

**存储未配置**：若 API 返回 `Storage not configured` 或 503，提示：「复习功能需要服务端配置存储，暂时不可用。今日诗和验收仍可正常使用。」

---

## 五、诗人缘分模式

**流程**：`GET {URL}/api/poet-affinity?days=30` → 得到 `poets` 数组（含 `author`、`count`、`poems`）。

**输出**：轻松、像「缘分测试」的语气。
- 第一名：你和 **{author}** 最有缘！他的诗出现了 {count} 次。
- 可举 1–2 首诗名为例
- 列出前 3–5 名及次数
- 收尾一句俏皮话（如「说不定你骨子里也有几分豪迈洒脱呢～」）

**示例**：
```
📜 诗人缘分 · 最近30天

你和 **李白** 最有缘！他的诗出现了 5 次，《月下独酌》《静夜思》《春思》……

其次：杜甫 3 次，王维 2 次。

说不定你骨子里也有几分豪迈洒脱呢～
```

---

## 六、规则与语气

- **一天一诗**：同一日期全世界同一首，不做「再抽一次」
- **讲解**：用自己的话，2–3 句，不照抄
- **验收**：语气鼓励，允许小错
- **复习**：题型多样，逐题反馈，不一次扔完
- **诗人**：轻松有趣，像抽签
- **语言**：默认中文

---

## 七、API 速查

**Base URL**：从技能配置 `DAILY_TANG_POEM_API_URL` 读取，默认值在 manifest 中定义，用户安装后无需配置。  
**鉴权**：仅当配置了 `DAILY_TANG_POEM_API_KEY` 时，每个请求追加 `?key=配置值`；未配置则不追加。

| 端点 | 参数 | 返回 |
|------|------|------|
| `GET /` | `date`（可选，YYYY-MM-DD，默认今天） | `id`, `title`, `author`, `type`, `contents`, `contents_normalized`, `recite_lines`, `recite_lines_normalized` |
| `GET /api/review` | `user_id`（必填）, `count`=5（1–10） | `{items: [...], total}` 或 `{items:[], message}` |
| `POST /api/pass` | body: `{user_id, date, poem_id}` | `{ok:true}` |
| `GET /api/poet-affinity` | `days`=30（1–365） | `{days, poets: [{author, count, poems: [{date, title, id}]}]}` |
