# Technical Analysis Reference

Use technical analysis as a decision support layer, not as a standalone certainty signal.

## 1. Trend Framework

1. Moving averages:
- 20/50/200-period moving averages as baseline trend map.
- Bullish regime: price above key moving averages with supportive slope.
- Bearish regime: price below key moving averages with negative slope.

2. Trend strength:
- Confirm with higher highs/higher lows (uptrend) or lower highs/lower lows (downtrend).

## 2. Momentum Framework

1. RSI:
- Overbought > 70, oversold < 30.
- Use divergence vs price as an early warning, not a standalone trigger.

2. MACD:
- Track line/signal crossovers and histogram trend.
- Prefer signals aligned with broader trend.

## 3. Volatility and Structure

1. ATR context:
- Use ATR expansion/contraction to assess regime change risk.

2. Bollinger context:
- Squeeze can precede expansion.
- Band walk can persist in strong trends.

## 4. Support and Resistance

Map levels from:

- Recent swing highs/lows
- Volume clusters
- Moving-average confluence
- Psychological round numbers

Use level breaks with volume confirmation where possible.

## 5. Volume Confirmation

1. Breakout quality improves with volume expansion.
2. Weak volume breakouts carry higher failure risk.
3. Divergence between price trend and volume trend can signal exhaustion.

## 6. Multi-Timeframe Alignment

1. Use higher timeframe (weekly/daily) for primary bias.
2. Use lower timeframe (daily/intraday where available) for timing.
3. Do not let lower timeframe noise override higher timeframe structure without strong evidence.

## 7. Signal Quality Rules

1. Require at least two independent confirmations before strong directional calls.
2. Mark low-confidence calls when indicators conflict.
3. Define invalidation level for every directional view.

## 8. Market-Specific Notes (US/CN/HK)

1. Liquidity and session structure differ by market.
2. Gap behavior and close auction effects may vary.
3. Technical indicator reliability can degrade during event-driven sessions.

## 9. Daily Output Guidance

At minimum provide:

- Trend state (bullish/neutral/bearish)
- 2-3 key levels
- RSI/MACD summary
- volume confirmation status
- invalidation condition
