# Authoritative Information Sources

Use search engines with `site:` filters to prioritize authoritative sources.

## Source Priority

1. Tier 1 (Primary / official)
- Exchange and regulator disclosures
- Company investor-relations pages
- Official macro data publishers

2. Tier 2 (High-quality financial media/data)
- Yahoo Finance, Reuters, Bloomberg, WSJ, CNBC, MarketWatch

3. Tier 3 (Supporting context)
- TradingView, StockCharts, sector/ETF summaries

For critical values (close price, earnings, guidance, major filings), cross-check with at least two independent sources.

## Tier 1: Exchange and Regulatory Sources

### Global baseline
- Company Investor Relations pages
- Official exchange announcements for the ticker listing venue

### United States
- SEC EDGAR: [https://www.sec.gov/edgar/searchedgar/companysearch](https://www.sec.gov/edgar/searchedgar/companysearch)
- Nasdaq company pages: [https://www.nasdaq.com](https://www.nasdaq.com)
- NYSE company pages: [https://www.nyse.com](https://www.nyse.com)

### Hong Kong
- HKEXnews: [https://www.hkexnews.hk](https://www.hkexnews.hk)

### Mainland China
- SSE disclosures: [https://www.sse.com.cn/disclosure/](https://www.sse.com.cn/disclosure/)
- SZSE disclosures: [https://www.szse.cn/disclosure/](https://www.szse.cn/disclosure/)

### Japan
- JPX: [https://www.jpx.co.jp/english/](https://www.jpx.co.jp/english/)
- TDnet (Timely Disclosure): [https://www.release.tdnet.info/](https://www.release.tdnet.info/)

### United Kingdom
- London Stock Exchange RNS: [https://www.londonstockexchange.com/news](https://www.londonstockexchange.com/news)

### Europe (multi-country)
- Euronext news/disclosures: [https://live.euronext.com/en/markets](https://live.euronext.com/en/markets)

## Tier 2: High-Quality Financial Data and News

- Yahoo Finance: [https://finance.yahoo.com](https://finance.yahoo.com)
- Reuters Markets: [https://www.reuters.com/markets/](https://www.reuters.com/markets/)
- Bloomberg Markets: [https://www.bloomberg.com/markets](https://www.bloomberg.com/markets)
- WSJ Markets: [https://www.wsj.com/market-data](https://www.wsj.com/market-data)
- CNBC Markets: [https://www.cnbc.com/markets/](https://www.cnbc.com/markets/)
- MarketWatch: [https://www.marketwatch.com](https://www.marketwatch.com)
- Morningstar (supporting valuation context): [https://www.morningstar.com](https://www.morningstar.com)

## Tier 1 Macro Data (for market regime context)

### United States
- U.S. Treasury rates: [https://home.treasury.gov](https://home.treasury.gov)
- Federal Reserve (FRED): [https://fred.stlouisfed.org](https://fred.stlouisfed.org)
- BLS: [https://www.bls.gov](https://www.bls.gov)
- BEA: [https://www.bea.gov](https://www.bea.gov)

### Global
- IMF Data: [https://www.imf.org/en/Data](https://www.imf.org/en/Data)
- World Bank Data: [https://data.worldbank.org](https://data.worldbank.org)
- ECB: [https://www.ecb.europa.eu](https://www.ecb.europa.eu)
- BoE: [https://www.bankofengland.co.uk](https://www.bankofengland.co.uk)
- BoJ: [https://www.boj.or.jp/en/](https://www.boj.or.jp/en/)

## Technical/Charting Support (Tier 3)

- TradingView: [https://www.tradingview.com](https://www.tradingview.com)
- StockCharts: [https://stockcharts.com](https://stockcharts.com)

## Search Engine Patterns

Use search engines with domain filters:

- `site:finance.yahoo.com <TICKER> quote`
- `site:reuters.com <TICKER> earnings`
- `site:sec.gov <TICKER> 10-Q`
- `site:hkexnews.hk <TICKER> announcement`
- `site:sse.com.cn <TICKER> 公告`
- `site:szse.cn <TICKER> 公告`
- `site:investor.<company-domain> earnings release`

## Minimum Source Set Per Run

At least include:

1. One Tier-1 disclosure source
2. One Tier-2 market data source (Yahoo Finance is acceptable baseline)
3. One Tier-2/Tier-1 news source
4. One macro source if macro is cited in thesis

## Compatibility Mode Minimum Source Set

When running in minimal compatibility mode, use:

1. One Tier-1 disclosure source
2. One Tier-2 market data source (Yahoo Finance acceptable)
