# Fundamental Analysis Reference

Use this framework in both `daily` and `full_report` modes. Keep outputs concise unless full report is requested.

## 1. Business Quality

Assess:

1. Moat quality:
- Brand, network effects, switching costs, cost advantage, IP/regulatory barriers.

2. Management quality:
- Capital allocation discipline, communication quality, execution consistency.

3. Business model durability:
- Revenue concentration, customer concentration, geographic risk, pricing power.

## 2. Financial Health

Focus areas:

1. Profitability trend:
- Gross, operating, net margin direction.

2. Growth quality:
- Revenue and earnings growth consistency, segment contribution quality.

3. Balance sheet:
- Debt burden, liquidity, refinancing risk, cash buffer.

4. Cash flow quality:
- OCF consistency, FCF conversion, capex intensity.

## 3. Valuation Lens

Use multiple perspectives:

1. Relative multiples:
- P/E, PEG, P/B, P/S, EV/EBITDA, EV/Sales.

2. Historical range context:
- Current valuation vs own history.

3. Peer context:
- Premium/discount vs direct peers and rationale.

## 4. Risk Framework

Map risks by category:

1. Company-specific:
- Product concentration, customer concentration, execution risk, governance issues.

2. Market/macro:
- Rate sensitivity, FX exposure, commodity sensitivity, policy risk.

3. Event risk:
- Earnings, regulatory approvals, legal actions, financing events.

## 5. Market-Specific Notes (US/CN/HK)

1. Data depth may vary by market and language.
2. Prefer exchange filings and official disclosure portals in each market.
3. Align accounting period labels and fiscal calendars before comparison.
4. Flag where metric comparability is limited.

## 6. Output Guidance

For daily mode, include:

- 2-3 key fundamental drivers
- 1-2 valuation signals
- top downside risks

For full report mode, include full multi-year trend tables and peer comparison.
