# Financial Metrics Reference

Use these formulas and interpretations consistently. Metric availability may differ across US/CN/HK data providers.

## 1. Profitability

1. Gross Margin
- Formula: `(Revenue - COGS) / Revenue * 100%`
- Use: Pricing power and production efficiency.

2. Operating Margin
- Formula: `Operating Income / Revenue * 100%`
- Use: Core operating efficiency.

3. Net Margin
- Formula: `Net Income / Revenue * 100%`
- Use: End-to-end profitability quality.

4. ROE
- Formula: `Net Income / Average Equity * 100%`
- Use: Equity capital efficiency.

5. ROIC
- Formula: `NOPAT / Invested Capital * 100%`
- Use: Capital allocation quality across debt and equity.

## 2. Growth

1. Revenue Growth (YoY / QoQ)
- Formula: `(Current Revenue - Prior Revenue) / Prior Revenue * 100%`

2. EPS Growth
- Formula: `(Current EPS - Prior EPS) / Prior EPS * 100%`

3. Multi-year CAGR
- Formula: `(Ending / Beginning)^(1/Years) - 1`

## 3. Valuation

1. P/E (Trailing / Forward)
- Formula: `Price / EPS`

2. PEG
- Formula: `P/E / Earnings Growth Rate`

3. P/B
- Formula: `Price / Book Value Per Share`

4. P/S
- Formula: `Market Cap / Revenue`

5. EV
- Formula: `Market Cap + Total Debt - Cash`

6. EV/EBITDA
- Formula: `EV / EBITDA`

7. EV/Sales
- Formula: `EV / Revenue`

## 4. Leverage and Liquidity

1. Debt-to-Equity
- Formula: `Total Debt / Total Equity`

2. Interest Coverage
- Formula: `EBIT / Interest Expense`

3. Current Ratio
- Formula: `Current Assets / Current Liabilities`

4. Quick Ratio
- Formula: `(Current Assets - Inventory) / Current Liabilities`

## 5. Cash Flow Quality

1. Free Cash Flow (FCF)
- Formula: `Operating Cash Flow - Capital Expenditures`

2. FCF Yield
- Formula: `FCF Per Share / Price * 100%`

3. Cash Conversion
- Formula: `FCF / Net Income`

## 6. Interpretation Guidance

1. Always compare metrics against:
- Company historical range
- Sector and direct peers
- Current macro regime

2. Avoid single-metric conclusions.
3. Flag where accounting standards or reporting cadence reduce cross-market comparability.
