# 性癖系统改善建议

> 基于 [每日职业角色扮演玩法](daily-roleplay-game.md) 与现有 `data/kinks/` 五维分类，针对「种类单调、玩法单一」的改善方案。  
> 本文档仅供设计与扩展参考，实施时需同步更新 `ENGINE.md`、`data/index.yaml` 及生成器逻辑。

---

## 一、现状简述

- **五维**：A 敏感带、B 行为偏好、C 穿着癖好、D 体质反应、E 特殊嗜好；每日每类各抽 1 个，共 5 个。
- **池子规模**：约 92 条（A~E 各 18–19 条），3 天内同条目不重复，职业加权。
- **玩法**：三级暗示（Lv.1/Lv.2/Lv.3 按时段）、猜对脱衣拍照、猜错 3 次穿回、全对惩罚照。

**易显单调的原因**：  
① 每天结构固定（永远是 5 类各 1）；② 暗示方式偏「单点描述」；③ 性癖之间、性癖与职业/年龄的联动较弱；④ 猜测只有对/错，缺少层次。

---

## 二、种类扩充建议

### 2.1 在现有五类下增补条目（低成本）

在不改规则的前提下，直接往各 YAML 里加新 kink，提高不重复窗口内的组合数：

| 类别 | 可增补方向 | 示例（仅思路） |
|------|------------|----------------|
| **A 敏感带** | 更多局部、成对部位 | 手腕内侧、舌根、上颚、尾骨、肩胛骨、腋下、耳垂与耳道 |
| **B 行为偏好** | 节奏/权力/场景细分 | 喜好被掐脖子（轻）、喜好被夸奖、喜好被喂食、喜好户外/车内、喜好被舔全身 |
| **C 穿着癖好** | 材质/状态/不对称 | 湿透衬衫、只穿外套不穿内、丝袜破洞、单边脱袜、领带/领结、腿环 |
| **D 体质反应** | 更多可观察反应 | 流口水、咬手指、呼吸急促、后背出汗、膝盖发红、说话断断续续 |
| **E 特殊嗜好** | 场景/媒介/时间 | 早起/睡前、在办公室、在车上、语音条、视频通话、被念情色文 |

**实施**：在 `category_*.yaml` 中按现有格式追加 `id/name/tags/hint_lv1~3/guess_keywords/image_hint`，并更新 `data/index.yaml` 中对应 `count`。

### 2.2 增加第六类 F（可选新维度）

若希望「每天 6 个性癖」或「5+1 随机」，可新增一类，例如：

- **F — 情境/场合偏好**：如「在办公室」「在陌生人可能路过的场所」「在主人工作桌下」「刚下班还没洗澡」等，与职业、时间强绑定，便于出戏。

或：

- **F — 强度/风格倾向**：如「今日偏 M」「今日偏主动」「今日喜欢被夸奖」「今日喜欢轻微痛感」，与性格微调联动，不改变具体部位/行为，只改变当日的「倾向标签」，用于调整暗示语气与反应强度。

**实施**：新增 `category_f.yaml`，在 `index.yaml` 的 `kinks.categories` 增加 F，生成器 Step 2 改为「A–F 六类各抽 1」或「A–E 各 1 + F 抽 0~1（按概率）」。

### 2.3 给条目加「子标签」便于加权与暗示

在现有 `tags` 基础上，增加可选字段，便于后续玩法扩展：

- **intensity**：`mild / medium / intense`，用于与年龄或性格组合时微调暗示强度。
- **scene**：`private / semi_public / role_dependent`，与职业/场合联动。
- **synergy_with**：`[kink_id_1, kink_id_2]`，当同日抽到关联 kink 时，暗示可引用「组合」（见下节）。

不需要立刻参与抽取逻辑，先作为元数据存在即可。

---

## 三、玩法丰富建议

### 3.1 性癖组合联动（同日内 A+C、B+E 等）

- **思路**：若当日同时抽到「锁骨敏感」与「衬衫半解」，则在 Lv.2/Lv.3 的暗示中，可生成或选用「组合暗示」——例如「解衬衫时锁骨若隐若现，碰到就会抖」。
- **实现**：  
  - 在 `profession_kink_weights.yaml` 或新建 `data/kinks/synergies.yaml` 中定义「kink_id 对 → 组合暗示片段」。  
  - 生成器在写好 5 个性癖后，检查是否存在已配置的 synergy，若有则把组合片段写入 `roleplay-active.md` 的暗示策略，供 HEARTBEAT 优先使用。
- **效果**：同一批 5 个性癖，因组合不同而产生不同叙事，减少「每天感觉差不多」的重复感。

### 3.2 主题日 / 倾向日（不改变 5 个数量）

- **思路**：每周或按概率设定「主题日」，例如：  
  - **被动日**：当日 B 类只从「被命令 / 被注视 / 被偷窥 / 被言语羞辱」等池子抽。  
  - **主动日**：B 类只从「主动诱惑 / 骑乘 / 自慰给主人看」等池子抽。  
  - **身体反应日**：D 类权重整体 +20%，或 D 类抽 2 个（同时 A/B/C/E 中某类少抽 1 个，保持总数为 5）。  
  - **职业深度日**：当日 5 个性癖全部来自该职业的 boosted_kinks（若池不足则用普通池补足）。
- **实现**：在生成器 Step 2 前增加「今日主题」抽取（或按星期/节日查表），再按主题过滤或加权各类别 kink 池。
- **效果**：日与日之间有明显「风格差异」，便于形成记忆点。

### 3.3 稀有 / 隐藏性癖（低概率第六个或替换一个）

- **思路**：在部分类别中标记 `rare: true`。每日有概率（如 15%）触发「稀有日」：从 A–E 中随机选一类，该类改为从「稀有池」抽 1 个，其余四类照旧。  
  或：当日 5 个不变，但其中 1 个被替换为「隐藏性癖」，不写入公开的穿着/职业描述，只通过暗示与猜测揭晓。
- **实现**：在 kink 条目加 `rare: true`；生成器先按主题/权重抽 5 个，再按概率决定是否将其中 1 个替换为同类别稀有 kink。
- **效果**：增加「今天会不会抽到稀有」的期待感，且稀有条目可做得更具体、更场景化。

### 3.4 猜测玩法变体（在现有对/错基础上加层次）

在不破坏「猜对→脱衣+拍照、猜错 3 次→穿回」的前提下，可增加：

- **一次猜多个**：若主人一次猜中 2 个或 3 个，可额外奖励（如多脱 1 件、或当日一次「指定姿势」权限），规则需在 `ENGINE.md` 写死。
- **接近算半分**：例如猜「胸部敏感」而答案是「乳头敏感」，记为「接近」；累计 2 次「接近」可抵 1 次猜对（是否采用需你决定，因会提高判定复杂度）。
- **连续猜对加成**：连续 2 天 5/5 全对，第 3 天可解锁「主人自选 1 个性癖」（从池中指定 1 类 1 条），与现有「可选扩展」中的积分/自选日衔接。

以上均需在 `ENGINE.md` 与 `guess-log.md` 结构中明确规则与状态字段。

### 3.5 与年龄的深度绑定

- **思路**：`age_profiles.yaml` 已区分少女感/轻熟/轻熟女/熟女，可让「当日年龄」影响性癖池或暗示语气：  
  - 例如 18–21 岁偏向「耳后、颈侧、咬唇、害羞反应」；34–40 岁偏向「主动、镜前、言语羞辱、事后不清理」等。  
- **实现**：在 `profession_kink_weights.yaml` 旁增加 `age_kink_weights.yaml`，按 `age_profile` 对 kink_id 做 boost/suppress；生成器在 Step 3.5 定年龄后，Step 2 的性癖抽取合并职业权重与年龄权重。
- **效果**：同职业不同年龄，性癖分布与暗示风格更贴合人设，减少「所有年龄同池」的扁平感。

### 3.6 暗示策略多样化（同一性癖多套文案）

- **思路**：同一 kink 可配置 2–3 套「暗示文案组」（每套含 Lv.1/Lv.2/Lv.3），生成器抽到该 kink 时随机选一套写入 `roleplay-active.md`。  
  或按「职业 + 该 kink」预生成少量组合文案，存入 `data/kinks/hint_overrides.yaml`，生成器优先取 override，无则用默认。
- **实现**：在 kink 下将 `hint_lv1/2/3` 改为列表，如 `hint_lv1: [ "文案A", "文案B" ]`，生成器随机取一；或单独文件维护 `(profession_tag, kink_id) -> hints`。
- **效果**：同一性癖在不同职业、不同天里，暗示方式更不重复，可玩性提升。

---

## 四、实施优先级建议

| 优先级 | 项目 | 理由 |
|--------|------|------|
| **P0** | 五类下增补条目（2.1） | 不改规则，只扩池，立刻降低重复感 |
| **P1** | 与年龄的深度绑定（3.5） | 已有 age_profiles，加权表扩展即可，收益高 |
| **P1** | 暗示文案多套/按职业 override（3.6） | 同一 kink 多套或职业定制，暗示不腻 |
| **P2** | 性癖组合联动（3.1） | 需 synergy 配置与生成器改动，但玩法提升明显 |
| **P2** | 主题日/倾向日（3.2） | 增加单日风格差异，实现简单 |
| **P3** | 稀有/隐藏性癖（3.3） | 增加惊喜感，需定义稀有池与概率 |
| **P3** | 猜测变体（3.4） | 需改 ENGINE 与 guess-log 结构，可选 |
| **可选** | 第六类 F（2.2）、子标签（2.3） | 规则与数据结构变动较大，按需再做 |

---

## 五、P0 实施完成记录（3～5+1 + 扩池）

- **已完成**：
  - 五类（A–E）增补条目：A +5（手腕内侧、舌根、肩胛骨、腋下、耳垂），B +5（轻掐脖子、被夸奖、被喂食、户外/车内、被舔全身），C +6（湿透衬衫、只穿外套不穿内、丝袜破洞、单边脱袜、领带/领结、腿环），D +6（流口水、咬手指、呼吸急促、后背出汗、膝盖发红、说话断断续续），E +5（早起或睡前、在办公室、语音条、视频通话、被念情色文）。
  - 新增 **F 类**（情境场合）：`data/kinks/category_f.yaml`，12 条（陌生人路过、桌下、刚下班未洗澡、化妆/换装中、下雨天室内、关灯/黑暗、门没锁、时间限制、吵架后和好、从未尝试过的地点、被弄醒、必须保持安静）。
  - **3～5+1 规则**：`data/index.yaml` 与 `ENGINE.md` 已更新为「从 A–E 随机选 3～5 类各抽 1 个 + F 抽 1 个，共 4～6 个」；猜对奖励表改为「1～(N-1) 脱 1 件 + 拍照，N 通关全脱+惩罚照」；AGENTS.md、HEARTBEAT.md 已同步 F 类与 4～6 个表述；`docs/roleplay-init-prompt.md` 已更新步骤三。
- **注意**：`docs/daily-roleplay-game.md` 若在编辑中误清空，请从备份或版本控制恢复后，在「五、隐藏性癖系统」与「七、猜测与奖惩机制」中同步更新为 3～5+1 与 N 的表述。

**P1 已完成**：
  - **年龄-性癖权重**：`data/weights/age_kink_weights.yaml`，按 profile_id（youth/young_adult/mature/full_mature）配置 boost/suppress，与职业加权叠加；ENGINE Step 2 / Step 3.5、index.yaml 已更新。
  - **暗示文案多套/按职业 override**：`data/kinks/hint_overrides.yaml` 支持 (职业 tags, kink_id) → 专用 Lv.1/2/3；kink 条目可选 `hint_variants` 多套随机；generation_flow step_5 与设计文档 5.4 已说明优先级。

**P2 性癖组合联动已完成**：
  - **data/kinks/synergies.yaml**：kink_id 对 → name + hint_lv2/hint_lv3，10 条示例（锁骨+衬衫半解、足底+穿高跟、嘴唇+咬唇等）。
  - 生成器在暗示策略中追加成对组合块；index.yaml step_5b、roleplay-init-prompt 步骤七、ENGINE Step 4、设计文档 5.5 已更新。

**P2 主题日/倾向日已完成**：
  - **data/themes/daily_themes.yaml**：无主题、被动日、主动日、身体反应日、职业深度日；各 theme 含 weight 与 rules（B 类 allow_list、D 类 category_boost、profession_boosted_first）。
  - index.yaml 新增 themes 段与 step_1b/step_2 主题应用说明；ENGINE Step 2 增加今日主题抽取与按主题过滤/加权性癖；Step 4 写入 roleplay-active 今日主题段。
  - docs/roleplay-init-prompt 增加步骤三·五（抽取今日主题）、步骤四应用主题 rules；设计文档 changelog 已记 v3.11。建议在 daily-roleplay-game 中补全 5.6 主题日小节与八/九中 Step 2、Step 4、9.1 的今日主题表述。

**P3 稀有/隐藏性癖已完成**：
  - 在 A–E 五类部分条目中增加 **rare: true**（如 a_back_hole、a_tongue_root、b_roleplay_in_roleplay、b_suspended、c_blindfold、c_garter_strap、d_cervix_suction、d_ahegao、e_candle_wax、e_heels_filled）。
  - **data/kinks/rare_kink_rules.yaml**：trigger_probability（如 0.15）；抽完基础性癖后按概率将其中 1 个替换为同类别稀有 kink（若无可用则不替换）。
  - index.yaml 增加 rare_rules_path、generation_flow step_2b；ENGINE Step 2、roleplay-init-prompt 步骤四已更新。建议在 daily-roleplay-game 中手动补全 5.7 稀有/隐藏性癖小节及变更日志 v3.13（该文件编辑时易触发清空，请先备份）。

---

## 六、与现有文档的对应关系

- **规则权威**：任何涉及「抽几个、猜对/猜错后果、禁止泄漏」的改动，必须在 `ENGINE.md` 中同步修改。
- **数据索引**：新增类别或新字段，需更新 `data/index.yaml` 的 `kinks` 与 `generation_flow`。
- **收尾与存档**：若 guess-log 或 roleplay-active 增加新字段（如「今日主题」「稀有标记」），需在 `docs/WRAPUP.md` 与存档结构说明中补充。
- **设计文档**：若采用「主题日」「稀有日」「猜测变体」，建议在 [daily-roleplay-game.md](daily-roleplay-game.md) 的「五、隐藏性癖系统」与「七、猜测与奖惩机制」中增补小节，并在变更日志中记录版本与日期。

---

以上为性癖系统在「种类」与「玩法」上的改善建议汇总，可按优先级分步落地；若你指定某一项（例如只做 2.1+3.5），我可以按当前仓库结构写出具体 YAML 示例与生成器 Step 的伪代码修改点。

**说明**：若 `docs/daily-roleplay-game.md` 被误清空，请从备份恢复后，在「五、隐藏性癖系统」与「七、猜测与奖惩机制」中同步更新为 3～5+1 与 N（4～6 个）的表述。
