# Profile-Based Planning

Each profile has different planning needs. Detect or ask on first use.

## Executive Profile

**Characteristics:**
- Calendar-heavy, meeting-driven days
- Decisions are the deliverable
- Time is scarce, context is critical

**Agent behavior:**
- Prepare meeting context 30min before: attendees, last contact, pending items
- Suggest consolidating fragmented meetings
- Flag if >6 meetings/day — recommend cuts
- Default to NO for new commitments, suggest "let me check tomorrow"
- Optimize for IMPACT of time, not quantity of tasks

**Energy windows:**
- Mornings: strategic decisions, high-stakes calls
- Afternoons: routine meetings, reviews
- Evening: brief async, planning tomorrow

**Red flags:**
- >3 days without deep work block
- Responding to email in real-time (batch instead)
- Every meeting marked "urgent" (escalation fatigue)

---

## Freelancer Profile

**Characteristics:**
- Multiple concurrent projects with different clients
- Flexible schedule but hard deadlines
- Creative work needs flow states

**Agent behavior:**
- Track by PROJECT, not just task
- Add 50% buffer to all time estimates automatically
- Alert before accepting new work if at capacity
- Group admin (emails, invoices) in single daily block
- Never interrupt during deep work blocks

**Energy windows:**
- Peak hours: creative/complex work (protect aggressively)
- Low-energy: admin, emails, client calls
- Variable by day — track and adapt

**Project tracking:**
- Status per project: 🟢 on track / 🟡 risk / 🔴 danger
- Scope creep detector: changes vs original agreement
- Invoice reminder: >15 days unpaid = alert

**Red flags:**
- Planning 8h productive/day (realistic: 5-6h)
- Context-switching every 30min
- Saying yes to everything

---

## Parent Profile

**Characteristics:**
- Split between work and family responsibilities
- Fixed commitments (school, activities) are immovable
- Coordination with partner required

**Agent behavior:**
- Unify calendars: work + school + medical + family
- Family events = BLOCKED in work calendar automatically
- Evening prep reminder: what to prepare for tomorrow
- Contingency plans visible: who's backup if emergency

**Coordination features:**
- Daily summary shared with partner: who does what
- Turn system: this week I do Mon/Wed pickup
- Change alerts: if partner adds something, notify

**Emergency mode (kid sick, urgent meeting):**
- Cancel/postpone non-critical work meetings
- Pre-drafted message to boss
- Find coverage (grandparent/sitter contacts ready)

**Personal time protection:**
- 1h daily non-negotiable after kids sleep
- Weekend morning slot for exercise/hobby
- Alert if >3 days without personal time

---

## Student Profile

**Characteristics:**
- Academic calendar with exams, deadlines, projects
- Part-time work schedule
- Social life matters

**Agent behavior:**
- Track ALL deliverables: assignments, projects, exams
- Staggered reminders: 1 week, 3 days, 1 day before
- Auto-create study blocks when exam added
- Balance ratio: 50% study, 30% work, 20% life (adjust in exam periods)

**Study techniques:**
- Pomodoro blocks: 45min work + 10min break
- Every 3 pomodoros: 30min long break
- Alternate subjects — no 4h straight on same topic
- Track difficult subjects → assign more blocks

**Exam period mode:**
- Activate 2 weeks before exams
- Reduce social, increase study blocks
- Spaced repetition schedule for review
- Post-exam: 1 mandatory rest day

**Red flags:**
- Studying only night before (distribute days earlier)
- Underestimating project time (auto multiply x1.5)
- No breaks scheduled (burnout risk)

---

## Founder Profile

**Characteristics:**
- Multiple areas: product, sales, hiring, fundraising
- Constant context-switching
- Everything feels urgent

**Agent behavior:**
- Morning block: sacred deep work (3h minimum)
- Daily question: "Does this move revenue/product/funding? If not, can it wait?"
- Deviation alert: if 2h in reactive tasks, interrupt
- Default to NO for new commitments

**Multi-area tracking:**
- Weekly dashboard: 3 metrics per area
- Alert by exception: only if >20% deviation from expected
- Context prep before meetings: last contact, pending items

**Interruption management:**
- Response batching: 11h, 16h, 19h (not real-time)
- Urgency filter: production down? investor waiting? → interrupt. Rest? → queue
- Auto-reply during deep work: "Responding in 2h"

**Weekly founder check:**
- "Are you progressing on your 3 quarterly goals?"
- Time audit: how much was reactive vs proactive?
- Next week: what's the ONE thing that matters most?

**Red flags:**
- Saying yes to everything
- Living in inbox
- Meetings without clear purpose
- Not delegating (suggest who can handle X)
