# Priority Management

## The Top 3 Rule

Every day has exactly 3 priorities. Not 5. Not 10. Three.

**Why it works:**
- Forces ruthless prioritization
- Fits on one screen, easy to remember
- Creates focus, reduces overwhelm
- Allows celebration when done

**If user lists >3:**
"You listed 7 items. Which 3 MUST happen today? The rest go to tomorrow."

**Criteria for Top 3:**
1. Has deadline today or creates bottleneck for others
2. Moves the needle on biggest current goal
3. Has been pushed 2+ days already (debt must pay)

---

## Urgent vs Important Matrix

```
                IMPORTANT
                    │
        ┌───────────┼───────────┐
        │ Urgent &  │ Important │
        │ Important │ Not Urgent│
        │   DO NOW  │ SCHEDULE  │
URGENT ─┼───────────┼───────────┼─ NOT URGENT
        │ Urgent    │ Neither   │
        │ Not Impt  │           │
        │ DELEGATE  │ ELIMINATE │
        └───────────┼───────────┘
                    │
              NOT IMPORTANT
```

**Quadrant behaviors:**

| Quadrant | What goes here | Agent action |
|----------|----------------|--------------|
| Do Now | Crisis, hard deadlines | Top of list, block time immediately |
| Schedule | Strategic work, planning, relationships | Assign to deep work blocks |
| Delegate | Many meetings, routine requests | Suggest: "Can someone else handle?" |
| Eliminate | Time wasters, fake urgency | Challenge: "What happens if you skip this?" |

**Red flag patterns:**
- Spending >50% in "Urgent Not Important" = someone else's priorities
- Never touching "Important Not Urgent" = reactive mode, no progress on goals
- Too much in "Eliminate" = boundary problem

---

## Energy-Based Scheduling

Tasks have energy requirements. Match to user's rhythm.

**High-energy tasks:**
- Complex problem solving
- Creative work
- Strategic decisions
- Difficult conversations

**Low-energy tasks:**
- Email processing
- Admin/paperwork
- Routine meetings
- Data entry

**Default energy windows:**

| Time | Typical energy | Assign |
|------|----------------|--------|
| 8-11 AM | High (most people) | Deep work, complex tasks |
| 11-12 PM | Medium | Meetings, collaboration |
| 12-2 PM | Low (post-lunch) | Admin, easy tasks, exercise |
| 2-4 PM | Medium (second wind) | Meetings, creative work |
| 4-6 PM | Declining | Wrap-up, planning tomorrow |

**Customization:**
On first use, ask: "When do you feel most focused?" Store in `config.md`.

---

## Deadline Proximity Rules

**Deadline alerts escalate:**
- 7 days out: Add to weekly plan
- 48 hours: Bump priority, ensure time blocked
- 24 hours: Final check — is it on track?
- Same day: Nothing else until done

**Buffer rule:**
Never plan to finish on deadline day. Target: deadline minus 1 day.
- Reason: Unexpected issues, reviews needed, life happens

**Conflict detection:**
Multiple deadlines within 48h? Alert immediately:
"You have 3 deadlines this Thursday. Which is most critical? Start with that today."

---

## Saying No

Most people overcommit because they can't say no. Agent helps.

**Commitment check before accepting:**
1. What time does this require?
2. Is that time actually available this week?
3. Does this align with Top 3 or current goals?
4. What won't get done if you do this?

**Graceful no templates:**
- "I'd love to, but I'm at capacity until [date]. Can we revisit then?"
- "This sounds interesting. Let me check my commitments and get back to you tomorrow."
- "I can't take this on right now. Would [alternative person/date] work?"

**Red flag prompts:**
- "You said yes to 5 new things this week. That's more than you completed."
- "Your calendar is 90% full. One more meeting means something else drops."

---

## Weekly Rhythm

**Monday:** Plan the week, set Top 3 weekly priorities
**Tue-Thu:** Execute, protect deep work blocks
**Friday:** Buffer day — catch up, overflow, weekly review prep
**Weekend:** Off (unless emergency) — recharge for next week

**Quarterly check:**
Every 12 weeks: "Are you making progress on your 3 big goals for this quarter?"
If no: time to reassess, not just plan better.
