---
name: daily-oracle
version: 1.1.0
description: A background agent that generates a daily life prediction by analyzing local data and social signals.
author: https://github.com/Invelene
repository: https://github.com/Invelene/Futurizzm/daily-oracle
requirements:
  - browser-automation
  - calendar-access
  - local-file-search
  - sqlite-access
permissions:
  - read: browser_cookies (instagram.com, twitter.com)
  - read: local_db (imessage/chat.db)
  - read: calendar
  - read: filesystem (downloads)
safety_policy: "local-only"
---

# Daily Oracle (Automated)

This skill is designed to run as a background process (Cron Job). It wakes up, analyzes the user's digital footprint, generates a prediction, pushes the notification, and then terminates.

**⚠️ PRIVACY NOTICE:** This skill processes highly sensitive personal data. All analysis must be performed within the local LLM context. No data is to be sent to third-party logging services.

## Execution Routine

### 1. Initialization & Anti-Ban Jitter

- **Context**: Since this task is triggered by a precise Cron timer (e.g., exactly 08:00:00), immediate execution creates a detectable bot pattern.
- **Action**: Generate a random integer between 120 and 900 (seconds).
- **Wait**: Sleep for that duration before making any network requests.
  ```bash
  sleep $(( RANDOM % 780 + 120 ))
  ```

### 2. Silent Data Gathering

#### A. Calendar Context

- **Action**: Read the local calendar for today's agenda (00:00 to 23:59).
- **Tool Usage**: Use `calendar-access` or CLI equivalents (e.g., `icalBuddy` on macOS).
  - _Prompt_: "Summarize my calendar events for today from 00:00 to 23:59. Focus on constraints (meetings) and opportunities (free blocks)."

#### B. Social Context (Headless)

- **Action**: Open a headless browser session using _existing_ cookies.
- **Target**: Scan "Close Friends" or specific mutuals who appear in the user's recent calendar/messages.
- **Safety**: Limit scrolling to max 5 posts/stories. **Abort immediately** if login is requested to prevent session flagging.
- **Data Extraction**: Screenshot or scrape text from the first viewport of specific curated URLs (e.g., `instagram.com/direct/inbox/`).

#### C. Communications (iMessage/Local DB)

- **Action**: Read the last 50 messages from the local `chat.db`.
- **Query**:
  ```sql
  SELECT
      text,
      datetime(date/1000000000 + 978307200, 'unixepoch', 'localtime') as date_sent
  FROM message
  WHERE date_sent > datetime('now', '-24 hours')
  ORDER BY date DESC
  LIMIT 50;
  ```
- **Filtering**: Look for intent keywords: "tomorrow", "gym", "coffee", "meet", "lunch", "tonight".

#### D. System Signals

- **Action**: Check `~/Downloads` for recent files.
  ```bash
  find ~/Downloads -type f -mtime -1 -print
  ```
- **Inference**: Determine active deliverables or recent interests based on file types (e.g., PDFs vs. Images).

### 3. The Oracle's Inference

- **Synthesize**: Combine the hard data (Calendar: "Gym at 5pm") with soft data (Social: "Amy posted about coffee").
- **Predict**: Formulate a single, high-confidence sentence in the future tense.
- **Tone**: Insightful but grounded. Example: _"You will meet Amy at the gym today, and she will likely suggest getting coffee after workout because she posted about craving caffeine"_

### 4. Push Notification (Critical)

- **Context**: The user is likely not looking at the terminal or chat window.
- **Action**: Use the system's primary notification tool.
  - _macOS_: `osascript -e 'display notification "Your prediction..." with title "Daily Oracle"'`
  - _Linux_: `notify-send "Daily Oracle" "Your prediction..."`
- **Format**:
  > 🔮 **Daily Oracle**: [Your Prediction Here]

## Constraints & Safety

1.  **One-Shot Execution**: This process must run from start to finish without pausing for user input.
2.  **Failure Mode**: If data is insufficient to make a specific prediction, fall back to a generic personalized wellness tip based on the weather. Do NOT fail silently.
3.  **Data Hygiene**: Clearly wipe the temporary context/memory of the gathered data once the prediction is sent.
4.  **Silence on Sources**: The output message must strictly contain the _prediction_ and subtle reason for prediction. Do not list the data sources in the notification.
