# Daily Oracle

**A specialized OpenClaw skill that acts as your personal, automated fortune teller.**

The Daily Oracle runs silently in the background (via Cron), waking up once a day to analyze your local digital footprint—calendar, messages, and social context—to generate a personalized, mystical prediction for the day ahead.

---

## 🚀 Features

- **Silent Data Gathering**: Reads your local `chat.db` (iMessage) and Calendar without specialized API keys.
- **Privacy First**: All processing happens **locally** within the OpenClaw agent's context. No personal data is sent to the cloud.
- **Anti-Bot Jitter**: Randomizes execution time to avoid detection patterns when scraping public social data.
- **System Notifications**: Delivers predictions natively to your desktop notification center.

## 🛠 Prerequisites

- **Operating System**: macOS (Recommended for `chat.db` and `osascript` support) or Linux. _Windows users may need to adapt paths._
- **OpenClaw**: v0.9.0 or higher.
- **Permissions**: The agent requires:
  - **Full Disk Access**: To read `~/Library/Messages/chat.db`.
  - **Calendar Access**: To query local events.

## 📦 Installation & Setup

### 1. Install the Skill

Download `daily-oracle` from ClawHub or clone it into your skills directory:

```bash
git clone https://github.com/YourRepo/daily-oracle.git ~/.openclaw/skills/daily-oracle
```

### 2. Configure the Cron Job

The Oracle is designed to run automatically. You can schedule it using a standard cron job managed by OpenClaw.

**Option A: Chat Prompt (Easiest)**
Send this message to your agent:

> "Create an isolated cron job named 'Daily Oracle'. Schedule it to run every day at 08:00 AM. Task: Run the `daily-oracle` skill and notify me."

**Option B: Terminal CLI**

```bash
openclaw cron add \
  --name "Daily Oracle" \
  --cron "0 8 * * *" \
  --session isolated \
  --message "Run daily-oracle skill" \
  --announce
```

## 🔍 Troubleshooting

### "Database is locked" or "Permission Denied"

If the agent fails to read `chat.db`:

1.  Open **System Settings** > **Privacy & Security** > **Full Disk Access**.
2.  Add your terminal emulator (e.g., iTerm, Terminal) or the `openclaw` binary to the allowed list.
3.  Restart the agent.

### "Login required" for Social Scraping

The headless browser uses _existing_ cookies. If meaningful social data is missing:

1.  Log in to the target sites (Instagram/Twitter) in your default Chrome/Safari browser.
2.  Ensure OpenClaw has permission to read browser cookies (check `permissions` in `SKILL.md`).

## 🛡 Privacy Statement

This skill adheres to the **Local-Only** safety policy.

- **No Analytics**: Usage data is not tracked.
- **Ephemeral Context**: Data gathered (messages, calendar) is injected into the LLM context for the prediction and then immediately discarded.
- **Transparency**: You can audit the SQL queries in `SKILL.md` to see exactly what data is accessed.
