---
name: daily-hot-push
version: 1.0.0
description: 每日推送中国热榜TOP10到飞书。从微博、知乎、百度、36氪筛选最重要的新闻，智能排除明星八卦和主观评论。
author: imgolye
metadata: 
  clawdbot:
    emoji: 🔥
    category: productivity
    tags: [news, daily, china, feishu, trending]
---

# 每日热榜推送

智能推送中国热榜 TOP10，让你不错过任何重要新闻。

## 功能特点

✅ **多源聚合** - 微博、知乎、百度、36氪四大平台
✅ **智能筛选** - 排除明星八卦、广告推广、主观评论
✅ **简洁输出** - 只推送10条最重要的新闻
✅ **定时推送** - 配合 OpenClaw Cron 每天早上8点自动推送
✅ **飞书集成** - 直接推送到飞书账号

## 使用场景

当你需要：
- 了解今日中国最热门的事件
- 每天早上自动收到热榜推送
- 避免信息过载，只看最重要的10条

## 数据源

1. **微博热搜榜** - 社会热点、舆论风向
   https://tophub.today/n/KqndgxeLl9

2. **知乎热榜** - 深度讨论、专业观点
   https://tophub.today/n/mproPpoq6O

3. **百度实时热点** - 大众关注、搜索趋势
   https://tophub.today/n/Jb0vmloB1G

4. **36氪24小时热榜** - 商业科技、创业动态
   https://tophub.today/n/Q1Vd5Ko85R

## 筛选标准

只推送符合以下标准的内容：

1. ✅ **重大事件** - 政策、国际关系、社会事件
2. ✅ **热议话题** - 引发广泛讨论的重要话题
3. ✅ **事实新闻** - 基于事实的报道，非主观评论
4. ❌ **排除** - 明星八卦、娱乐营销、广告推广

## 输出格式

```
======

🔥 今日热榜（03月01日）

1. 伊朗最高领袖哈梅内伊遇害，中东局势持续升级
2. 巴基斯坦对阿富汗公开宣战，边境激烈交火
3. 中国手机行业迎来全面涨价潮，存储芯片成本上涨超80%
4. FIBA向中国男篮致歉，为措辞不当道歉
5. 油价或出现历史性飙升，受中东局势影响
6. 伊朗导弹击中以军总参谋部，冲突持续升级
7. 领克语音助手误关大灯引发撞车，官方已道歉
8. 网警提醒规避考研查分陷阱，警惕诈骗
9. 86岁作家杨本芬承认抄袭，文学"抄袭"界定引讨论
10. 外卖新规要求"无堂食"标识，整治幽灵外卖

======
```

## 设置定时推送

使用 OpenClaw Cron 设置每天早上8点自动推送：

```bash
openclaw cron add \
  --name "每日热榜推送" \
  --cron "0 8 * * *" \
  --tz "Asia/Shanghai" \
  --channel "feishu" \
  --to "YOUR_FEISHU_USER_ID" \
  --message "使用 daily-hot-push 技能获取今日热榜TOP10并推送" \
  --announce
```

## 手动触发

直接对我说：
- "推送今日热榜"
- "查看今天的热搜"
- "给我10条最重要的新闻"

## 技术实现

1. 使用 `web_fetch` 从 tophub.today 获取各平台热榜
2. 使用 AI 智能筛选和去重
3. 按重要性和热度排序
4. 格式化输出并推送

## 与其他技能的区别

| 技能名称 | 数据源 | 筛选方式 | 推送平台 |
|---------|--------|---------|---------|
| **daily-hot-push** | 中国热榜 | AI智能筛选 | 飞书/多平台 |
| news-summary | 国际RSS | 简单聚合 | 通用 |
| morning-briefing | 个人任务 | 无筛选 | 通用 |

## 更新日志

### v1.0.0 (2026-03-01)
- ✨ 首次发布
- ✨ 支持微博、知乎、百度、36氪四大平台
- ✨ AI智能筛选，排除无效信息
- ✨ 支持飞书定时推送
- ✨ 简洁的10条输出格式

## 反馈与建议

如有问题或建议，请在 ClawHub 上提交 issue。

---

**Keywords**: 每日热榜, 热搜推送, 中国新闻, 飞书推送, daily news, trending, china
