"""
每日热榜技能扩展模块

整合了以下功能：
- news_digest: 热点新闻摘要（15种标签分类）
- industry_hot: 行业热榜垂直（十大行业分类）
- personalized: 个性化订阅（关键词/平台/排除项配置）
- cross_platform: 跨平台聚合（TOP10聚合）
- sentiment_monitor: 舆情监控（关键词过滤）
"""

from .news_digest import (
    NewsDigest,
    DigestConfig,
    DigestMode,
    TAG_MAPPING,
    ALL_TAGS,
    create_digest as create_news_digest
)

from .industry_hot import (
    IndustryHot,
    IndustryConfig,
    IndustryMode,
    INDUSTRIES,
    ALL_INDUSTRIES,
    create_industry_hot
)

from .personalized import (
    PersonalizedSubscription,
    UserPreferences,
    SubscriptionMode,
    KEYWORD_OPTIONS,
    PLATFORM_OPTIONS,
    EXCLUDE_OPTIONS,
    create_personalized
)

from .cross_platform import (
    CrossPlatformAggregator,
    CrossPlatformConfig,
    create_cross_platform
)

from .sentiment_monitor import (
    SentimentMonitor,
    SentimentConfig,
    SentimentType,
    create_sentiment_monitor
)

__all__ = [
    # News Digest
    "NewsDigest",
    "DigestConfig",
    "DigestMode",
    "TAG_MAPPING",
    "ALL_TAGS",
    "create_news_digest",
    
    # Industry Hot
    "IndustryHot",
    "IndustryConfig",
    "IndustryMode",
    "INDUSTRIES",
    "ALL_INDUSTRIES",
    "create_industry_hot",
    
    # Personalized
    "PersonalizedSubscription",
    "UserPreferences",
    "SubscriptionMode",
    "KEYWORD_OPTIONS",
    "PLATFORM_OPTIONS",
    "EXCLUDE_OPTIONS",
    "create_personalized",
    
    # Cross Platform
    "CrossPlatformAggregator",
    "CrossPlatformConfig",
    "create_cross_platform",
    
    # Sentiment Monitor
    "SentimentMonitor",
    "SentimentConfig",
    "SentimentType",
    "create_sentiment_monitor"
]
