<div align="center">

# 🔥 Daily Hot News - OpenClaw Skill

[![GitHub stars](https://img.shields.io/github/stars/one-box-u/openclaw-daily-hot-news)](https://github.com/one-box-u/openclaw-daily-hot-news/stargazers)
[![GitHub forks](https://img.shields.io/github/forks/one-box-u/openclaw-daily-hot-news)](https://github.com/one-box-u/openclaw-daily-hot-news/network)
[![MIT License](https://img.shields.io/badge/License-MIT-blue.svg)](LICENSE)

---

**🇺🇸 English Readme** | **📖 [中文说明](README.md)**

---

A hot news aggregation skill based on DailyHotApi, supporting 54 platform hot search queries, cross-platform aggregation, and sentiment monitoring.

</div>

## 🎯 Features

### Core Features
- **Hot Search Query**: Query hot search data from any of 54 platforms
- **Category Browse**: Quickly locate specific platforms by category
- **History**: Automatically save daily hot search data

### Extended Features
- **Hot News Digest**: 15-tag classification, AI-guided selection
- **Industry Vertical**: 10 industry categories (tech, gaming, finance, etc.)
- **Personalized Subscription**: Custom keywords and platform preferences
- **Cross-Platform Aggregation**: Top 10 hot search榜单 nationwide
- **Sentiment Monitoring**: Keyword monitoring and hot alerts

## 📊 Supported Platforms (54)

### 🎬 Video/Live Streaming (5)
| Platform | API | Description |
|----------|------|------|
| Bilibili | bilibili | Hot Ranking |
| AcFun | acfun | Ranking List |
| Douyin | douyin | Hot Topics |
| Kuaishou | kuaishou | Hot Topics |
| Coolapk | coolapk | Hot Ranking |

### 💬 Social Media (8)
| Platform | API | Description |
|----------|------|------|
| Weibo | weibo | Hot Search |
| Zhihu | zhihu | Hot List |
| Zhihu Daily | zhihu-daily | Recommended |
| Tieba | tieba | Hot Discussion |
| Douban Group | douban-group | Discussion Picks |
| V2EX | v2ex | Topic Ranking |
| NGA | ngabbs | Hot Posts |
| Hupu | hupu | Street Hot Posts |

### 📰 News & Media (10)
| Platform | API | Description |
|----------|------|------|
| Baidu | baidu | Hot Search |
| The Paper | thepaper | Hot List |
| Toutiao | toutiao | Hot List |
| 36kr | 36kr | Hot List |
| QQ News | qq-news | Hot Topics |
| Sina | sina | Hot List |
| Sina News | sina-news | Hot Topics |
| NetEase News | netease-news | Hot Topics |
| Huxiu | huxiu | 24 Hours |
| Ifanr | ifanr | Quick News |

### 💻 Tech/Developer Communities (8)
| Platform | API | Description |
|----------|------|------|
| IT Home | ithome | Hot List |
| IT Home Xijiayi | ithome-xijiayi | Latest Updates |
| Sspai | sspai | Hot List |
| CSDN | csdn | Ranking List |
| Juejin | juejin | Hot List |
| 51CTO | 51cto | Recommended |
| NodeSeek | nodeseek | Latest Updates |
| HelloGitHub | hellogithub | Trending |

### 🎮 Gaming/ACG (5)
| Platform | API | Description |
|----------|------|------|
| Genshin | genshin | Latest News |
| MiyouShe | miyoushe | Latest News |
| Honkai 3 | honkai | Latest Updates |
| StarRail | starrail | Latest Updates |
| LOL | lol | Update Notice |

### 📚 Reading/Culture (4)
| Platform | API | Description |
|----------|------|------|
| Jianshu | jianshu | Popular Recommendations |
| Guokr | guokr | Popular Articles |
| WeRead | weread | Rising List |
| Douban Movie | douban-movie | New Movies |

### 🔧 Tools/Other (5)
| Platform | API | Description |
|----------|------|------|
| 52pojie | 52pojie | Ranking List |
| HostLoc | hostloc | Ranking List |
| Weather Alarm | weatheralarm | National Warning |
| Earthquake | earthquake | Earthquake Report |
| History Today | history | Month-Day |

## 🚀 Quick Start

### 1. Deploy Backend Service

```bash
cd daily-hot-api
./deploy.sh
```

### 2. Install Dependencies

```bash
pip install -r requirements.txt
```

### 3. Configure Environment Variables

```bash
export DAILY_HOT_API_URL=http://localhost:6688
```

### 4. Run

```bash
python3 daily_hot_news.py --query "weibo hot"
```

## 💬 Usage Examples

### Example 1: Query Single Platform

```bash
# Query Weibo hot search
python3 daily_hot_news.py -q "微博热搜"

# Query Zhihu hot list
python3 daily_hot_news.py -q "知乎热榜"

# Query Bilibili trending
python3 daily_hot_news.py -q "B站热门"

# Query Genshin latest
python3 daily_hot_news.py -q "原神"
```

**Output**:
```
🔥 **Weibo Hot Search**
Update Time: 2026-02-05T19:00:00.000Z

1. Wang Yibo Zhongshan Suit 5.2M
2. Xiao Zhan Shy Smile 4.8M
3. Weibo Night Red Carpet 4.5M
...
```

### Example 2: Browse All Platforms

```bash
# View all supported hot search sources
python3 daily_hot_news.py --list
```

**Output**:
```
📊 **Supported Hot Search Sources (54)**

🎬 Video/Live Streaming
• Bilibili (bilibili)
• Douyin (douyin)
• Kuaishou (kuaishou)
• AcFun (acfun)
• Coolapk (coolapk)

💬 Social Media
• Weibo (weibo)
• Zhihu (zhihu)
• V2EX (v2ex)
• NGA (ngabbs)
...
```

### Example 3: Cross-Platform Aggregation

```bash
# View nationwide Top 10
python3 daily_hot_news.py --cross-platform
```

**Output**:
```
🌐 Nationwide Hot Topics TOP10

🥇 Genshin Update · 9.52M 【Highest on Bilibili】
   Score: 98 - 🔥 Super Popular
   Discussed on 5 platforms

🥈 Weibo Hot · 8.76M 【Highest on Weibo】
   Score: 95 - Nationwide Discussion

🥉 Trump · 6.54M 【Highest on Weibo】
   Score: 89 - International Topic
...
```

### Example 4: Set Sentiment Monitoring

```bash
# Set monitoring: AI topic, alert when exceeds 5M
python3 daily_hot_news.py --monitor "AI,500万"

# View monitoring configuration
python3 daily_hot_news.py -q "查看我的监控"
```

**Output**:
```
✅ **Monitoring Set!**

Monitoring Keyword: AI
Hot Threshold: 5M
Platforms: All 54

I'll notify you when any topic exceeds the threshold!
```

### Example 5: Scheduled Push Configuration

```bash
# Configure daily 8 AM Weibo hot push
"每天早上 8 点推送微博热搜"
```

**Output**:
```
⏰ **Scheduled Push Configured!**

Push Time: Daily 08:00
Hot Source: Weibo Hot Search
Push Method: Feishu Message

I'll automatically push Weibo hot to your Feishu every morning at 8!
```

## 🎮 Advanced Usage

### Query by Category

```bash
# View tech hot searches
"有什么科技热榜"

# View gaming hot topics
"游戏有什么热点"
```

### Search Specific Topics

```bash
# Search for topics containing keywords
"搜索 AI 相关热榜"
"查找 ChatGPT 热点"
```

### View Historical Data

```bash
# View yesterday's Weibo hot
"微博昨天"

# View history records
"微博历史"
```

### View Saved Data

```bash
# View saved hot search statistics
"已保存了哪些数据"
```

## 📁 File Structure

```
daily-hot-news/
├── daily_hot_news.py       # Main Entry
├── news_digest.py        # Hot News Digest
├── industry_hot.py        # Industry Vertical
├── personalized.py        # Personalized Subscription
├── cross_platform.py     # Cross-Platform Aggregation
├── sentiment_monitor.py   # Sentiment Monitoring
├── api_client.py        # API Client
├── formatter.py         # Formatter
├── storage.py          # Data Storage
├── config.py           # Configuration
├── requirements.txt    # Dependencies
└── README.md           # This Document
```

## ⚙️ Configuration

| Environment Variable | Default | Description |
|---------------------|---------|-------------|
| `DAILY_HOT_API_URL` | http://localhost:6688 | Backend API URL |
| `DAILY_HOT_CACHE_TTL` | 3600 | Cache Time (seconds) |
| `DAILY_HOT_MAX_ITEMS` | 20 | Max Items Returned |
| `DAILY_HOT_TIMEOUT` | 10 | Request Timeout (seconds) |

## 🛡️ Security Note

- ✅ No API keys or passwords included
- ✅ All sensitive configurations managed via environment variables
- ✅ User data stored locally, not uploaded to cloud

## 📝 Changelog

**v2.0.0** (2026-02-05)
- ✨ Added 5 extended features
- ✨ Support 15 hot tag classifications
- ✨ Support 10 industry vertical hot searches
- ✨ Added personalized subscription feature
- ✨ Added cross-platform TOP10 aggregation
- ✨ Added sentiment monitoring alerts

## 📄 License

MIT License

## 🤝 Acknowledgements

- [DailyHotApi](https://github.com/imsyy/DailyHotApi) - Providing 54 hot search source APIs
- [OpenClaw](https://github.com/openclaw/openclaw) - AI Assistant Platform
