<div align="center">

# 🔥 每日热榜 - OpenClaw Skill

[![GitHub stars](https://img.shields.io/github/stars/one-box-u/openclaw-daily-hot-news)](https://github.com/one-box-u/openclaw-daily-hot-news/stargazers)
[![GitHub forks](https://img.shields.io/github/forks/one-box-u/openclaw-daily-hot-news)](https://github.com/one-box-u/openclaw-daily-hot-news/network)
[![MIT License](https://img.shields.io/badge/License-MIT-blue.svg)](LICENSE)

---

**📖 [中文说明](README.md)** | **🇺🇸 [English Readme](README_EN.md)**

---

一个基于 DailyHotApi 的热榜聚合查询技能，支持 54 个平台热榜查询、跨平台聚合、舆情监控等功能。

</div>

## 🎯 功能特性

### 核心功能
- **热榜查询**：查询任意 54 个平台的热榜数据
- **分类浏览**：按类别快速定位特定平台
- **历史记录**：自动保存每日热榜数据

### 扩展功能
- **热点摘要**：15 种标签分类，AI 引导选择
- **行业垂直**：十大行业分类，科技/游戏/金融等
- **个性化订阅**：自定义关键词和平台偏好
- **跨平台聚合**：全网 TOP10 热点榜单
- **舆情监控**：关键词监控和热度告警

## 📊 支持平台（54 个）

### 🎬 视频/直播平台（5 个）
| 平台 | 接口 | 说明 |
|------|------|------|
| 哔哩哔哩 | bilibili | 热门榜 |
| AcFun | acfun | 排行榜 |
| 抖音 | douyin | 热点榜 |
| 快手 | kuaishou | 热点榜 |
| 酷安 | coolapk | 热榜 |

### 💬 社交媒体（8 个）
| 平台 | 接口 | 说明 |
|------|------|------|
| 微博 | weibo | 热搜榜 |
| 知乎 | zhihu | 热榜 |
| 知乎日报 | zhihu-daily | 推荐榜 |
| 百度贴吧 | tieba | 热议榜 |
| 豆瓣讨论小组 | douban-group | 讨论精选 |
| V2EX | v2ex | 主题榜 |
| NGA | ngabbs | 热帖 |
| 虎扑 | hupu | 步行街热帖 |

### 📰 新闻资讯（10 个）
| 平台 | 接口 | 说明 |
|------|------|------|
| 百度 | baidu | 热搜榜 |
| 澎湃新闻 | thepaper | 热榜 |
| 今日头条 | toutiao | 热榜 |
| 36氪 | 36kr | 热榜 |
| 腾讯新闻 | qq-news | 热点榜 |
| 新浪网 | sina | 热榜 |
| 新浪新闻 | sina-news | 热点榜 |
| 网易新闻 | netease-news | 热点榜 |
| 虎嗅 | huxiu | 24小时 |
| 爱范儿 | ifanr | 快讯 |

### 💻 科技/技术社区（8 个）
| 平台 | 接口 | 说明 |
|------|------|------|
| IT之家 | ithome | 热榜 |
| IT之家「喜加一」 | ithome-xijiayi | 最新动态 |
| 少数派 | sspai | 热榜 |
| CSDN | csdn | 排行榜 |
| 稀土掘金 | juejin | 热榜 |
| 51CTO | 51cto | 推荐榜 |
| NodeSeek | nodeseek | 最新动态 |
| HelloGitHub | hellogithub | Trending |

### 🎮 游戏/ACG（5 个）
| 平台 | 接口 | 说明 |
|------|------|------|
| 原神 | genshin | 最新消息 |
| 米游社 | miyoushe | 最新消息 |
| 崩坏3 | honkai | 最新动态 |
| 崩坏：星穹铁道 | starrail | 最新动态 |
| 英雄联盟 | lol | 更新公告 |

### 📚 阅读/文化（4 个）
| 平台 | 接口 | 说明 |
|------|------|------|
| 简书 | jianshu | 热门推荐 |
| 果壳 | guokr | 热门文章 |
| 微信读书 | weread | 飙升榜 |
| 豆瓣电影 | douban-movie | 新片榜 |

### 🔧 工具/其他（5 个）
| 平台 | 接口 | 说明 |
|------|------|------|
| 吾爱破解 | 52pojie | 榜单 |
| 全球主机交流 | hostloc | 榜单 |
| 中央气象台 | weatheralarm | 全国气象预警 |
| 中国地震台 | earthquake | 地震速报 |
| 历史上的今天 | history | 月-日 |

## 🚀 快速开始

### 1. 部署后端服务

```bash
cd daily-hot-api
./deploy.sh
```

### 2. 安装依赖

```bash
pip install -r requirements.txt
```

### 3. 配置环境变量

```bash
export DAILY_HOT_API_URL=http://localhost:6688
```

### 4. 运行

```bash
python3 daily_hot_news.py --query "微博热搜"
```

## 💬 使用案例

### 案例 1：查询单个平台热榜

```bash
# 查询微博热搜
python3 daily_hot_news.py -q "微博热搜"

# 查询知乎热榜
python3 daily_hot_news.py -q "知乎热榜"

# 查询 B站热门
python3 daily_hot_news.py -q "B站热门"

# 查询原神最新消息
python3 daily_hot_news.py -q "原神"
```

**效果**：
```
🔥 **微博热搜**
更新时间: 2026-02-05T19:00:00.000Z

1. 王一博 中山装 520万
2. 肖战 害羞笑 480万
3. 微博之夜红毯 450万
...
```

### 案例 2：浏览所有平台

```bash
# 查看所有支持的热榜源
python3 daily_hot_news.py --list
```

**效果**：
```
📊 **支持的热榜源（共 54 个）**

🎬 视频/直播
• 哔哩哔哩 (bilibili)
• 抖音 (douyin)
• 快手 (kuaishou)
• AcFun (acfun)
• 酷安 (coolapk)

💬 社交媒体
• 微博 (weibo)
• 知乎 (zhihu)
• V2EX (v2ex)
• NGA (ngabbs)
...
```

### 案例 3：跨平台聚合

```bash
# 查看全网热点 TOP10
python3 daily_hot_news.py --cross-platform
```

**效果**：
```
🌐 全网热点 TOP10

🥇 原神 · 热度 952万 【B站最高】
   评分: 98分 - 🔥 超级爆款
   跨 5 平台讨论

🥈 微博热搜 · 热度 876万 【微博最高】
   评分: 95分 - 全网讨论

🥉 特朗普 · 热度 654万 【微博最高】
   评分: 89分 - 国际话题
...
```

### 案例 4：设置舆情监控

```bash
# 设置监控：AI 话题，热度超过 500 万通知
python3 daily_hot_news.py --monitor "AI,500万"

# 查看监控配置
python3 daily_hot_news.py -q "查看我的监控"
```

**效果**：
```
✅ **已设置监控！**

监控关键词：AI
热度阈值：500万
监控平台：全部 54 个

当有话题热度超过阈值时，我会立即通知您！
```

### 案例 5：定时推送配置

```bash
# 配置每天早上 8 点推送微博热搜
"每天早上 8 点推送微博热搜"
```

**效果**：
```
⏰ **定时推送已设置！**

推送时间：每天 08:00
热榜源：微博热搜
推送方式：飞书消息

每天早上 8 点会自动推送微博热榜到您的飞书！
```

## 🎮 高级用法

### 按类别查询

```bash
# 查看科技类热榜
"有什么科技热榜"

# 查看游戏类热榜
"游戏有什么热点"
```

### 搜索特定话题

```bash
# 搜索包含某个关键词的热榜
"搜索 AI 相关热榜"
"查找 ChatGPT 热点"
```

### 查看历史数据

```bash
# 查看昨天的微博热榜
"微博昨天"

# 查看历史记录
"微博历史"
```

### 查看已保存数据

```bash
# 查看已保存的热榜统计
"已保存了哪些数据"
```

## 📁 文件结构

```
daily-hot-news/
├── daily_hot_news.py       # 主入口
├── news_digest.py        # 热点摘要
├── industry_hot.py        # 行业垂直
├── personalized.py        # 个性化订阅
├── cross_platform.py     # 跨平台聚合
├── sentiment_monitor.py  # 舆情监控
├── api_client.py        # API 客户端
├── formatter.py         # 格式化器
├── storage.py          # 数据存储
├── config.py          # 配置
├── requirements.txt    # 依赖列表
└── README.md          # 本说明
```

## ⚙️ 配置说明

| 环境变量 | 默认值 | 说明 |
|----------|--------|------|
| `DAILY_HOT_API_URL` | http://localhost:6688 | 后端 API 地址 |
| `DAILY_HOT_CACHE_TTL` | 3600 | 缓存时间（秒） |
| `DAILY_HOT_MAX_ITEMS` | 20 | 返回最大条数 |
| `DAILY_HOT_TIMEOUT` | 10 | 请求超时（秒） |

## 🛡️ 安全说明

- ✅ 不包含任何 API 密钥或密码
- ✅ 所有敏感配置通过环境变量管理
- ✅ 用户数据存储在本地，不上传云端

## 📝 更新日志

**v2.0.0** (2026-02-05)
- ✨ 新增 5 个扩展功能
- ✨ 支持 15 种热点标签分类
- ✨ 支持十大行业垂直热榜
- ✨ 新增个性化订阅功能
- ✨ 新增跨平台 TOP10 聚合
- ✨ 新增舆情监控告警

## 📄 许可证

MIT License

## 🤝 致谢

- [DailyHotApi](https://github.com/imsyy/DailyHotApi) - 提供 54 个热榜源 API
- [OpenClaw](https://github.com/openclaw/openclaw) - AI 助手平台
