---
name: daily-gushiwen
description: 每日从古诗文网(gushiwen.cn)首页爬取诗词文句、古画名句等内容，整理后发送为消息。用于用户询问"每日古文"、"古诗"、"诗词推荐"或需要每日古文推荐时触发。
---

# 每日古文

从古诗文网首页(gushiwen.cn)获取当日的诗词文句、古画配句、名句摘录等，整理后发送。

## 使用方式

用户在以下场景会触发此skill：
- 询问"每日古文"、"今日古诗"、"古文推荐"
- 询问"今天有什么古诗"
- 需要获取古诗文网首页的精选内容

## 执行流程

1. **获取首页内容**: 使用 exec+curl 或 tavily_extract 访问 https://www.gushiwen.cn/
2. **解析内容**: 提取以下信息
   - 诗词文句：标题、作者、朝代、正文（不包含标签）
   - 古画配句：古画名称（如"高其佩 山水册-画册局部"）及其下的名句评论，**古画图片URL**（格式：`https://ziyuan.guwendao.net/mingjuImg/{图片ID}.jpg`）
   - 名句摘录：经典名句及其出处
3. **古画图片URL提取方法**: 使用 exec+curl 抓取页面HTML，用正则表达式匹配 `<img src="https://ziyuan.guwendao.net/mingjuImg/` 获取图片URL
4. **整理格式**: 按以下结构组织消息
   - 开头：日期 + 每日古文标题（格式：`📜 每日古文 · X年X月X日`）
   - 诗词：按网站顺序
     - 标题：《诗题》
     - 作者：〔朝代〕作者名
     - 正文：诗句
   - 古画：按网站顺序，紧跟对应诗词后面
     - 古画名称（如"山水册-画册局部"）
     - 作者（如"高其佩"）
     - [图片]占位符
     - 名句
     - ——《出处》
   - 名句摘录：
     - • 名句内容
     - 出处（不要破折号，直接给出处）
   - 各区块之间用 `======` 分隔
5. **发送消息**: 将整理好的内容发送（通过 message 工具或 cron job 的 delivery）
   - 古画图片使用 message 工具的 media 参数发送
   - [图片]占位符的位置就是发送图片的时机

## 输出格式示例（不要直接用示例，按上面的步骤网络爬取内容输出！）

```
📜 每日古文 · 2026年2月19日

---
《采菱》
〔宋〕范成大

采菱辛苦废犁锄，血指流丹鬼质枯。
无力买田聊种水，近来湖面亦收租！

---
山水册-画册局部
高其佩

[图片]

"当断不断，反受其乱"
——《史记·七十列传·春申君列传》

---
《归鸟·其一》
〔魏晋〕陶渊明
翼翼归鸟，晨去于林。
远之八表，近憩云岑。
和风不洽，翻翮求心。
顾俦相鸣，景庇清阴。

---
野花草虫图局部
丘余庆

[图片]

"野花不种年年有，烦恼无根日日生。"
——《警世通言·卷二十》

---
• 不以一眚掩大德。
《左传·僖公·僖公三十三年》
• 有治法而后有治人。
《明夷待访录·原法》
• 好水好山看不足，马蹄催趁月明归。
岳飞《池州翠微亭》
```


## 注意事项

- 古诗文网内容会每日更新，首页展示的是网站推荐内容
- 不输出长篇古文以控制消息长度
- 古画配句通常是一句经典名句，来自古籍
- 确保内容正确解析URL链接
- **古画图片URL格式**: `https://ziyuan.guwendao.net/mingjuImg/{图片ID}.jpg`，从HTML的 `<img src="https://ziyuan.guwendao.net/mingjuImg/` 标签中提取
- 发送古画图片时使用 message 工具的 media 参数，图片URL需要是可访问的公网URL
- 如果是在QQ里调用的话，不输出图片相关内容。
- 不加赏析
- 分割线“---”用“======”代替
- 只输出要求输出的内容，前后不要输出多余的文本、说明、报错