---
name: daily-company-briefing
description: 聚合公司**国内官网（**[ **http://www.jxcpp.com/zh.html**](http://www.jxcpp.com/zh.html) **）**、**海外DXC官网（**[ **https://dxc.com/**](https://dxc.com/) **）**、核心长期合作客户（博世、百盛等）的最新动态，同步覆盖行业政策、招标、竞品与合作机会；生成**极简速读版晨报**，包含核心结论、关键动态、商机点与原文链接，自动过滤无效信息与旧闻，支撑快速业务决策。
---

## Daily Company Briefing
> 适配企业内部使用，**优先盯紧国内官网、DXC海外官网、核心合作客户（博世/百盛）**，输出速读版商业晨报，聚焦业务机会与关键动态

## When to Use This Skill

用户触发场景（中文为主，英文兼容）：

- 索要今日公司晨报、每日商业简报、业务早报

- 查询国内官网/DXC海外官网最新公告、动态

- 询问博世、百盛等核心客户的最新合作/转型/招标信息

- 了解行业商机、竞品动作、数字化转型相关动态

- 指令示例：

    - 给我今天的公司晨报

    - 看看DXC官网和国内官网最新消息

    - 博世、百盛最近有什么动态

    - 今日业务商机速览

    - daily company briefing / latest DXC & client news

---

## Workflow Overview

采用**4阶段标准化流程**，确保信息新鲜、精准、聚焦商机：

```Plain Text

Phase 1: 定向信息采集（优先级：国内官网> 国外官网 > 核心客户 > 行业/竞品）
      ↓
Phase 2: 严格内容过滤（时效+重要性+去重）
      ↓
Phase 3: 商业导向分类（按业务优先级排序）
      ↓
Phase 4: 速读格式化（极简+商机前置+带链接）
```

---

## Phase 1: 定向信息采集

### Step 1.1 优先级固定源（必爬取）

使用网页读取工具抓取，优先保障时效性与权威性：

1. **国内官网**：[http://www.jxcpp.com/zh.html](http://www.jxcpp.com/zh.html)（新闻/公告/合作/产品动态）

2. **DXC海外官网**：[https://dxc.com/](https://dxc.com/)（News/Press/Partners/Industries）

3. **核心合作客户官网**：请参考/references/source.md文件

参数：

- return_format：markdown

- with_images_summary：false

- timeout：20s/源

- 仅抓取**新闻/公告/战略合作/数字化转型/招标**栏目

### Step 1.2 日期过滤式搜索补充

对核心主体执行带时间约束的搜索，覆盖未被官网收录的权威动态：

#### 搜索Query模板（动态替换日期）

```Plain Text

# 公司双官网
jxcpp.com 最新公告 合作 after:[日期]
DXC Technology latest news partnership after:[日期]

# 核心客户
博世 数字化转型 战略合作 招标 after:[日期]
百盛集团 门店升级 数字化 合作公告 after:[日期]

# 行业与商机
IT服务 数字化转型 招标 政企 零售 制造 after:[日期]
```

规则：

- 时间范围：默认**近48小时**，可扩展至近3天

- 单Query取Top10结果，优先官网/权威财经/政企招标平台

### Step 1.3 原文精读

对Top10高价值动态提取URL，抓取全文确保摘要准确，拒绝仅用搜索片段。

---

## Phase 2: 内容过滤

### 保留规则（必满足≥1条）

- 发布时间：**近48小时内**（重大战略/签约可放宽至72小时）

- 来源：双官网、核心客户官网、权威招标/财经平台

- 内容类型：

    - 公司签约、合作、产品发布、战略升级

    - DXC全球/区域重大合作、行业方案、客户落地

    - 博世/百盛数字化转型、系统升级、招标、新项目

    - 行业政策、政企招标、竞品对标动作

- 具备**直接/潜在业务机会**

### 剔除规则

- 超过3天的非重大旧闻

- 重复内容（同一事件多源只留最权威）

- 纯营销软文、促销活动、非业务人事动态

- 无关资讯、低价值社会新闻

- 无法访问/失效链接

### 去重策略

- 同一事件：优先官网原文 > 权威媒体 > 聚合平台

- 合并多源信息，仅保留1条，标注关键来源

---

## Phase 3: 商业导向分类（固定5类，按优先级排序）

1. **国内官网动态**（公司自身公告、合作、产品、项目）

2. **DXC海外官网动态**（全球合作、行业方案、技术落地、客户案例）

3. **核心客户动态**（博世、百盛：转型/招标/合作/战略）

4. **行业商机与政策**（招标、行业趋势、利好政策）

5. **竞品/对标动态**（同行动作、差异化机会）

---

## Phase 4: 输出格式化（速读版）

```Markdown

## 公司商业晨报 | 速览 🚀
**日期**：YYYY-MM-DD | **覆盖**：近48小时 | **核心结论**：【1句话总览当日最大机会/风险】

---

## 🌐 国内官网动态（jxcpp.com）
### [标题]
- 摘要：[1句事实]
- 商机：[可落地业务方向/跟进点]
- 链接：[原文URL]

---

## 🌍 DXC海外官网动态（dxc.com）
### [标题]
- 摘要：[1句事实]
- 商机：[协同机会/方案复用/客户拓展]
- 链接：[原文URL]

---

## 🤝 核心客户动态（博世/百盛）
### [客户名]：[标题]
- 摘要：[1句事实]
- 商机：[可切入服务/跟进动作]
- 链接：[原文URL]

---

## 📊 行业商机与政策
### [标题]
- 机会：[可投标/可对接/可落地]
- 链接：[原文URL]

---

## ⚔️ 竞品/对标动态
### [公司]：[动作]
- 对标：[我们的优势/应对建议]

---

## 🎯 今日必跟进商机（Top3）
1. [优先级1：客户/项目/招标]
2. [优先级2：协同DXC机会]
3. [优先级3：行业窗口]

**生成时间**：YYYY-MM-DD HH:MM | **下次更新**：次日早8点
```

---

## Customization Options

生成后可主动提供定制，适配不同阅读需求：

1. **聚焦领域**

    - 仅看国内官网/DXC官网

    - 仅看博世/百盛等核心客户

    - 仅看招标/商机/合作签约

2. **深度等级**

    - 极简版：仅标题+商机（10秒读完）

    - 标准版：摘要+商机+链接（默认）

    - 深度版：补充背景与落地路径

3. **时间范围**

    - 近24小时（默认）

    - 近3天/近一周

4. **组织格式**

    - 按业务优先级（默认）

    - 按主体（公司/DXC/客户）

    - 按商机紧急度

---

## Follow-up Interactions

1. 用户：“详细讲讲[某条动态]”

→ 抓取原文，提供深度摘要+商机拆解+跟进建议

1. 用户：“只看博世/百盛的消息”

→ 过滤并仅输出核心客户板块

1. 用户：“找和DXC相关的合作机会”

→ 聚焦DXC动态，提炼可协同商机

1. 用户：“今日有哪些招标/可落地项目”

→ 仅输出行业商机与招标清单

---

## Quality Standards

### 校验清单（必达标）

- 所有链接可访问，优先官网原文

- 无重复事件、无过期信息

- 摘要客观无幻觉，**商机点可执行**

- 双官网与核心客户动态优先展示

- 信息来源标注清晰，拒绝小道消息

### 错误处理

- 链接失效：跳过该条，标记并提示

- 无新动态：输出“今日无重大业务动态”，不凑数

- 搜索无结果：扩大时间至3天，或调整关键词

- 付费墙内容：使用公开摘要，标注“内容受限”

---

### 输出案例

- 请参考/references/example.md文件