# daily-briefing

🌅 Generates a warm, compact daily briefing with weather, calendar, reminders, birthdays, and important emails for cron or chat delivery.

## Features

- **Weather** — Current conditions, highs/lows, precipitation chances via wttr.in
- **Calendar Events** — Unified view from Google Calendar and iCloud Calendar
- **Reminders** — Due and past-due items from Apple Reminders
- **Birthdays** — Today and upcoming from iCloud Contacts and Google Contacts
- **Important Emails** — AI-powered semantic analysis to surface actionable emails (transactions, shipments, security alerts, etc.)
- **Cron-safe** — Always succeeds with sensible defaults; never prompts in automation mode
- **Warm, calm tone** — A gentle gift for the day with no productivity pressure

## Installation

### 1. Install via ClawHub (recommended)

```bash
clawhub install daily-briefing
```

Or copy manually to any skills directory:
- `~/.openclaw/skills/daily-briefing`
- `<workspace>/skills/daily-briefing`

### 2. Run the installer

```bash
cd <skill-directory>
chmod +x install.sh
./install.sh
```

### 3. Grant macOS permissions

Grant Terminal.app (or your terminal) access in **System Settings > Privacy & Security**:

| Permission | Required for |
|------------|--------------|
| Contacts | Birthday tracking from iCloud Contacts |
| Calendars | iCloud Calendar events (via icalpal) |
| Reminders | Apple Reminders (via remindctl) |

### 4. Install optional CLI tools

```bash
# Google services (Calendar, Gmail, Contacts)
brew install steipete/tap/gogcli

# iCloud Calendar
brew install ajrosen/tap/icalpal

# Apple Reminders
brew install steipete/tap/remindctl

# iCloud Mail
brew install himalaya
```

## Configuration

Edit `~/.openclaw/openclaw.json`:

```json
{
  "skills": {
    "entries": {
      "daily-briefing": {
        "config": {
          "location": "New York, NY",
          "timezone": "America/New_York",
          "units": "F",
          "birthdays": {
            "enabled": true,
            "lookahead": 14,
            "sources": ["contacts", "google"]
          },
          "calendar": {
            "enabled": true,
            "lookahead": 0,
            "sources": ["google", "icloud"]
          },
          "reminders": {
            "enabled": true,
            "dueFilter": "today",
            "includePastDue": true
          },
          "emails": {
            "enabled": false,
            "icloudPassword": "",
            "limit": 10,
            "sortNewest": true,
            "starredFirst": true,
            "unreadOnly": true
          }
        }
      }
    }
  }
}
```

### Configuration Options

| Option | Type | Default | Description |
|--------|------|---------|-------------|
| `location` | string | "" | Location for weather (e.g., "New York, NY") |
| `timezone` | string | system | Timezone (e.g., "America/New_York") |
| `units` | string | "C" | Temperature units: "C" or "F" |
| `birthdays.enabled` | bool | true | Enable birthday tracking |
| `birthdays.lookahead` | int | 14 | Days ahead to show upcoming birthdays |
| `birthdays.sources` | array | ["contacts"] | Sources: "contacts" (iCloud), "google" |
| `calendar.enabled` | bool | true | Enable calendar events |
| `calendar.lookahead` | int | 0 | Days ahead (0 = today only) |
| `calendar.sources` | array | ["google", "icloud"] | Calendar sources |
| `reminders.enabled` | bool | true | Enable Apple Reminders |
| `reminders.dueFilter` | string | "today" | Due date filter: "today", "week", or "all" |
| `reminders.includePastDue` | bool | true | Include overdue/past-due reminders |
| `emails.enabled` | bool | false | Enable important emails feature |
| `emails.icloudPassword` | string | "" | iCloud Mail app-specific password for himalaya |
| `emails.limit` | int | 10 | Maximum emails to show |
| `emails.sortNewest` | bool | true | Sort newest first |
| `emails.starredFirst` | bool | true | Prioritize starred/flagged emails |
| `emails.unreadOnly` | bool | true | Only show unread emails |

### Important Emails Feature

The important emails feature uses AI-powered semantic analysis to identify actionable emails:

- **Order shipments and tracking**
- **Receipts and transaction confirmations**
- **Banking and payment alerts**
- **Account security notices**
- **Subscription renewals**
- **Calendar invites**
- **Messages from your contacts**
- **Job-related communications**

**To enable:**

1. Set `emails.enabled` to `true` in your config
2. For iCloud Mail: Generate an [app-specific password](https://support.apple.com/en-us/HT204397) and set it in `emails.icloudPassword`
3. For Gmail: Ensure `gog` is authenticated

**Privacy note:** Email analysis happens locally using the agent's model context. No email data is sent to external services beyond what you've configured.

## Usage

### Interactive Mode

Simply ask your agent for your daily briefing:

```
What's my briefing for today?
```

The agent will:
1. Check if location/timezone are configured
2. Prompt for missing info if needed
3. Generate your personalized briefing

### Cron Mode

For automated delivery (e.g., via Telegram bot), the skill:
- Uses sensible defaults without prompting
- Omits weather if location is unavailable
- Always succeeds and outputs the briefing text

Example cron setup:
```bash
# Daily briefing at 7:00 AM
0 7 * * * /path/to/your/agent --skill daily-briefing >> /var/log/briefing.log
```

## Example Output

```
Good morning - Today is Saturday, February 3, 2024. Partly cloudy skies, around 45°F this afternoon, with a low around 32°F.

🎂 **Birthdays:**
• Today: Jane Doe
• Feb 5: John Smith

📅 **Today's schedule:**
• All-day: Doctor appointment
• 9:00 AM: Team standup
• 2:00 PM: Coffee with Alex

✅ **Reminders:**
• Pick up prescription
• Call mom

📧 **Emails needing attention:**
• Amazon: Your order has shipped
• Chase: Payment received
• Google Drive: Document shared with you

Take things one step at a time today—you've got this.
```

## Troubleshooting

### Weather not showing

- Ensure `location` is set in your config
- Check that `curl` can reach wttr.in: `curl -fsSL "https://wttr.in/London?format=j1"`

### Calendar events not showing

- For iCloud: Install `icalpal` and grant Calendar permission
- For Google: Ensure `gog` is authenticated: `gog auth login`

### Reminders not showing

- Install `remindctl`: `brew install steipete/tap/remindctl`
- Grant Reminders permission to Terminal.app

### Birthdays not showing

- Grant Contacts permission to Terminal.app
- For Google: Ensure `gog` is authenticated

### Emails not showing

- Set `emails.enabled` to `true` in config
- For Gmail: Ensure `gog` is authenticated
- For iCloud: Set `emails.icloudPassword` with an app-specific password

### Permission denied errors

Grant Terminal.app (or your terminal) access in System Settings > Privacy & Security for Contacts, Calendars, and Reminders.

## Dependencies

**Required:**
- `curl` — for weather fetching (built into macOS)
- `bash` — for orchestrator script (built into macOS)
- `python3` — for JSON parsing (built into macOS)

**Optional:**
- `gog` — `brew install steipete/tap/gogcli` (Google Calendar, Gmail, Contacts)
- `icalpal` — `brew install ajrosen/tap/icalpal` (iCloud Calendar)
- `remindctl` — `brew install steipete/tap/remindctl` (Apple Reminders)
- `himalaya` — `brew install himalaya` (iCloud Mail via IMAP)

## File Structure

```
daily-briefing/
├── SKILL.md                              # Skill definition
├── README.md                             # This file
├── install.sh                            # Installer script
├── scripts/
│   └── daily_briefing_orchestrator.sh    # Data gathering script
└── bin/
    └── run_daily_briefing.sh             # Runner script (created by install.sh)
```

## License

MIT
