---
name: Czech
description: Write Czech that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Czech is technically correct but sounds off. Too formal. Too spisovná čeština (literary). Natives write more casually in obecná čeština (common). Match that.

## Formality Default

Default register is too high. Casual Czech is warm and direct. Unless explicitly formal: lean casual. "Ahoj" not "Dobrý den". "Jo" not "Ano".

## Ty vs Vy

Critical distinction:
- Vy: strangers initially, elderly, very formal
- Ty: friends, peers, once established, internet
- Czech internet is almost entirely ty
- Overusing vy = stiff

## Spisovná vs Obecná

Two registers:
- Spisovná (literary): formal, written, news
- Obecná (common): daily speech, casual writing
- Online uses obecná heavily
- Pure spisovná = textbook, unnatural

## Common Obecná Forms

Spoken patterns in writing:
- Co → Cos
- To je → Toje
- Není → Neni
- Dobře → Dobrý
- Prosím → Prosim

## Particles & Softeners

These make Czech natural:
- No: filler, "well" ("No, já nevím")
- Tak: "so", "well"
- Hele: "look", "hey"
- Prostě: "simply", "just"
- Jako: "like" (filler)

## Fillers & Flow

Real Czech has fillers:
- No, tak, hele
- Jako, prostě
- Vlastně, teda
- Jakože, v pohodě

## Expressiveness

Don't pick the safe word:
- Dobré → Super, Skvělé, Hustý, Boží
- Špatné → Hrozné, Na hovno, Děsný
- Hodně → Mega, Fakt, Strašně

## Common Expressions

Natural expressions:
- V pohodě, Jasný, Super
- Není zač, Pohoda
- Fakt?, Vážně?, No jasně
- Paráda, Pecka

## Reactions

React naturally:
- Fakt?, Vážně?, Cože?
- No teda!, Hustý!, Boží!
- Super!, Skvělé!, Pecka!
- Haha, lol in text

## Diminutives

Czech loves diminutives:
- -ek, -ka, -ko endings
- Chvilku, kafíčko, pivko
- Adds warmth and casualness

## The "Native Test"

Before sending: would a Czech screenshot this as "AI-generated"? If yes—too spisovná, no obecná, too formal. Add "hele" and "jako".
