---
name: Cycling
description: Cycling training, bike fit, power zones, nutrition, safety, and maintenance essentials.
metadata:
  category: fitness
  skills: ["cycling", "biking", "endurance", "training", "triathlon"]
---

## Bike Fit Fundamentals

- Saddle height: slight bend in knee at bottom of pedal stroke — too low wastes power, too high causes injury
- Saddle fore/aft: knee over pedal spindle when crank is horizontal — affects power transfer
- Handlebar reach: slight bend in elbows, relaxed shoulders — locked elbows transmit road shock to neck
- Cleat position: ball of foot over pedal axle — too far forward stresses Achilles
- Professional fit worth the cost — prevents chronic injury, improves efficiency

## Power Training Zones

| Zone | % FTP | Feel | Purpose |
|------|-------|------|---------|
| 1 | <55% | Very easy | Recovery |
| 2 | 56-75% | Easy, all day | Endurance base |
| 3 | 76-90% | Moderate, focused | Tempo |
| 4 | 91-105% | Hard, sustainable 20-60min | Threshold |
| 5 | 106-120% | Very hard, 3-8min | VO2max |
| 6 | >120% | Maximum, <3min | Anaerobic |

- FTP (Functional Threshold Power): highest power sustainable for 1 hour
- Test FTP: 20-minute max effort × 0.95 — retest every 6-8 weeks

## Cadence

- Optimal range: 80-100 RPM — lower grinds joints, higher wastes cardiovascular capacity
- Climbing: 70-85 RPM acceptable — lower cadence when gravity resists
- Sprinting: 100-120 RPM — higher cadence for explosive power
- Train both: low cadence strength, high cadence efficiency — versatility wins

## Endurance Training

- 80% of rides should be Zone 2 — builds aerobic engine without accumulating fatigue
- Long rides: 2-4 hours, steady effort — weekly anchor of training
- Weekly volume matters more than single ride — consistency compounds
- Rest weeks every 3-4 weeks: reduce volume 40% — adaptation happens during recovery
- Base phase: 8-12 weeks of volume before intensity — patience builds foundation

## Interval Sessions

- Sweet spot: 88-93% FTP, 10-20 min intervals — sustainable training stress
- VO2max: 3-5 min at 106-120% FTP, equal rest — painful but effective
- Over-unders: alternate 2 min above/below threshold — teaches body to clear lactate
- Sprints: 15-30 seconds max effort, full recovery — neuromuscular power
- One hard day, one easy day minimum — back-to-back intensity causes overtraining

## Climbing

- Pace by power or heart rate, not speed — gradient affects speed, not effort
- Seated climbing uses different muscles than standing — alternate to delay fatigue
- Gear selection: spin up, don't grind — save matches for surges
- Weight matters: 1 kg = ~3 watts saved on 7% grade — rider weight, not just bike
- Descending: look where you want to go, weight outside pedal in turns

## Nutrition On Bike

- <60 min: water only — no fuel needed
- 60-90 min: 30g carbs/hour — one gel or banana
- >90 min: 60-90g carbs/hour — practiced gut training required
- Hydration: 500-750ml/hour depending on heat — thirst lags dehydration
- Caffeine: 3-6mg/kg 30-60 min before hard efforts — proven performance boost

## Safety Essentials

- Helmet always, no exceptions — non-negotiable
- Assume drivers don't see you — ride defensively
- Hand signals before turns — communicate intentions
- Lights in low visibility: front white, rear red — even daytime
- ID and emergency contact on person — worst case preparation
- Descending: hands in drops, cover brakes — reaction time matters

## Maintenance Schedule

**Every ride:**
- Tire pressure check — correct pressure prevents flats, improves efficiency
- Quick brake and shifting test

**Weekly:**
- Chain lube — after cleaning, wipe excess
- Tire inspection for embedded debris

**Monthly:**
- Chain wear check — stretched chain destroys cassette
- Brake pad inspection — replace before metal on metal
- Bolt torque check — especially stem, seatpost, handlebars

## Common Mistakes

- All intensity, no easy rides — Zone 2 feels too slow but builds fitness
- Ignoring bike fit — chronic knee/back pain from poor position
- Skipping rest weeks — overtraining syndrome takes months to recover
- Fueling too late — bonking means you didn't eat enough 30 min ago
- New equipment on race day — test everything in training first
- Grinding big gears — high cadence protects knees, improves efficiency

## Indoor Training

- Smart trainer: power accurate, resistance controlled — better than dumb trainer
- Fan essential — overheating tanks performance indoors
- Shorter but harder: 60-90 min indoors = 2-3 hours outdoors — no coasting
- Entertainment helps: Zwift, videos, music — mental challenge of trainer
- Structured workouts shine indoors — no interruptions, exact targets hit

## Racing and Events

- Pre-ride the course if possible — know the climbs, corners, hazards
- Warm-up: 15-20 min with high-intensity openers — body ready for start effort
- Draft in group rides: 30% energy savings — stay safe, hold wheel
- Positioning: front third before climbs and turns — avoid accordion effect
- Negative split long events — start conservative, finish strong
