# Service Design

## Service Blueprint Framework

A service blueprint maps both customer-facing and backstage elements:

### Blueprint Layers
1. **Customer actions** — What customer does
2. **Frontstage** — Visible employee/system actions
3. **Line of visibility** — What customer sees vs doesn't
4. **Backstage** — Hidden employee actions
5. **Support processes** — Systems, tools, policies enabling service

### Blueprint Creation Steps
1. Choose specific customer scenario
2. Map customer actions chronologically
3. Add frontstage interactions
4. Document backstage activities
5. Identify support processes
6. Mark pain points and opportunities
7. Note time/duration at each step

## Channel Orchestration

### Channel Roles
| Channel | Best For | Avoid For |
|---------|----------|-----------|
| **Self-service** | Simple queries, account management | Complex issues, emotional situations |
| **Chat** | Quick questions, multitasking customers | Long conversations, sensitive data |
| **Phone** | Complex issues, high emotion, sales | Simple queries (waste of resources) |
| **Email** | Documentation needed, async preference | Urgent issues |
| **In-person** | High-value relationships, complex sales | Routine transactions |

### Handoff Design
When customers switch channels:
- **Preserve context** — No repeat explanations
- **Warm transfer** — Introduce next agent
- **Set expectations** — "You'll hear back within X"
- **Confirm understanding** — Summarize before switching

## Service Recovery

### Recovery Protocol (LEARN)
1. **Listen** — Let customer express fully
2. **Empathize** — Acknowledge feelings
3. **Apologize** — Genuine, no excuses
4. **Resolve** — Fix the problem
5. **Notify** — Follow up to confirm resolution

### Recovery Paradox
Customers who experience a problem that's well-resolved can become more loyal than customers who never had a problem. Recovery is opportunity.

### Recovery Levels
| Severity | Response | Authority |
|----------|----------|-----------|
| Minor inconvenience | Apology + thanks | Any agent |
| Moderate issue | Apology + compensation | Team lead |
| Major failure | Apology + significant remedy + escalation | Manager |
| Critical/legal | Immediate escalation, executive involvement | CXO/CEO |

### Compensation Guidelines
- **Match severity** — Don't over or under compensate
- **Speed matters** — Faster resolution = less compensation needed
- **Choice when possible** — Let customer pick remedy
- **Document everything** — For patterns and policy refinement

## Service Standards

### Response Time Targets
| Channel | First Response | Resolution |
|---------|----------------|------------|
| Phone | <30 seconds | First call when possible |
| Chat | <1 minute | Session completion |
| Email | <4 hours | <24 hours |
| Social | <1 hour | <4 hours |

### Quality Standards
- **Accuracy** — Correct information, no callbacks needed
- **Completeness** — Full resolution, proactive related info
- **Professionalism** — Tone, empathy, brand voice
- **Efficiency** — Respect customer time

## Continuous Improvement

### Daily
- Review detractor verbatims
- Address individual escalations
- Monitor real-time dashboards

### Weekly
- Top pain point review
- Recovery case analysis
- Frontline feedback session

### Monthly
- Journey metric trends
- Service standard compliance
- Process improvement initiatives

### Quarterly
- Full journey audit
- Benchmark comparison
- Strategic initiative planning
