# Experience Metrics and Voice of Customer

## Core Experience Metrics

### NPS (Net Promoter Score)
- **Question:** "How likely are you to recommend us?" (0-10)
- **Calculation:** % Promoters (9-10) - % Detractors (0-6)
- **Range:** -100 to +100
- **Use when:** Measuring loyalty and advocacy potential
- **Limitation:** Doesn't explain why; pair with follow-up

### CSAT (Customer Satisfaction)
- **Question:** "How satisfied were you with [interaction]?" (1-5)
- **Calculation:** % scoring 4 or 5
- **Use when:** Measuring specific touchpoint satisfaction
- **Limitation:** Moment-in-time, not predictive

### CES (Customer Effort Score)
- **Question:** "How easy was it to [complete task]?" (1-7)
- **Calculation:** Average score or % low effort (1-3)
- **Use when:** Measuring friction and usability
- **Most predictive:** Of repeat purchase and loyalty

## Metric Selection by Goal

| Goal | Primary Metric | Why |
|------|----------------|-----|
| Predict churn | CES | Effort drives disloyalty |
| Drive referrals | NPS | Promoters recommend |
| Fix touchpoints | CSAT | Immediate feedback |
| Product feedback | NPS + follow-up | Strategic insights |
| Support quality | CSAT + CES | Both matter |

## Voice of Customer Program

### Feedback Collection Channels
1. **Post-interaction surveys** — CSAT/CES at touchpoints
2. **Relationship surveys** — NPS quarterly/annually
3. **In-app feedback** — Real-time product feedback
4. **Support tickets** — Issue categorization and trends
5. **Social listening** — Unsolicited feedback
6. **Customer interviews** — Deep qualitative insights
7. **Reviews** — Public sentiment monitoring

### Survey Best Practices
- **Timing:** Ask when experience is fresh
- **Length:** Max 3-5 questions for transactional
- **Frequency:** Don't over-survey; max 1/quarter for relationship
- **Follow-up:** Always ask "why" after score
- **Close the loop:** Respond to detractors within 48h

### Insight Activation Cycle
1. **Collect** — Gather feedback systematically
2. **Analyze** — Find patterns, segment by persona/journey stage
3. **Prioritize** — Impact vs effort, strategic alignment
4. **Act** — Implement changes
5. **Communicate** — Tell customers you listened
6. **Measure** — Track if improvement moved metrics

## Leading vs Lagging Indicators

| Leading (Predictive) | Lagging (Outcome) |
|----------------------|-------------------|
| CES scores | Churn rate |
| Support ticket trends | NPS |
| Feature adoption | Revenue retention |
| Onboarding completion | LTV |
| Response times | Referral rate |

## Segmented Analysis

Always break metrics by:
- **Customer segment** — Enterprise vs SMB vs consumer
- **Journey stage** — Acquisition vs onboarding vs mature
- **Channel** — Web vs app vs phone
- **Tenure** — New vs established
- **Value tier** — High value vs standard

## Red Flags Dashboard

Trigger investigation when:
- NPS drops >5 points quarter-over-quarter
- CSAT falls below 80% for any touchpoint
- CES exceeds 4 (moderate effort)
- Detractor % exceeds 20%
- Support volume spikes without product changes
- Review sentiment turns negative
