# Customer Journey Mapping

## Journey Mapping Process

1. **Define scope** — Which persona, which journey (acquisition, onboarding, support, renewal)
2. **Map current state** — Document actual experience, not intended
3. **Identify touchpoints** — Every interaction across all channels
4. **Capture emotions** — Customer feelings at each stage
5. **Find pain points** — Friction, confusion, effort, wait times
6. **Prioritize fixes** — Impact vs effort matrix
7. **Design future state** — Intentional experience architecture

## Journey Stages Framework

| Stage | Customer Goal | Key Questions |
|-------|---------------|---------------|
| **Awareness** | Understand options | How do they discover us? First impression? |
| **Consideration** | Evaluate fit | What information do they need? Comparison points? |
| **Purchase** | Complete transaction | Friction in buying? Trust barriers? |
| **Onboarding** | Get value quickly | Time to first value? Complexity barriers? |
| **Usage** | Achieve goals | Task completion? Support needs? |
| **Advocacy** | Share success | What triggers referrals? Story worth telling? |

## Touchpoint Analysis

For each touchpoint, document:
- **Channel** — Where (web, app, phone, email, in-person)
- **Action** — What customer does
- **Emotion** — How they feel (positive, neutral, negative)
- **Effort** — How hard (easy, moderate, difficult)
- **Moment of truth** — Critical or routine?
- **Owner** — Who's responsible internally

## Moment Mapping

High-impact moments to always design intentionally:
- **First impression** — Initial contact sets expectations
- **First value** — When they get what they came for
- **First problem** — How recovery feels
- **Renewal/reorder** — Commitment decision point
- **Referral request** — When you ask for advocacy
- **Exit** — How leaving feels (affects return and reputation)

## Journey Anti-Patterns

| Problem | Symptom | Fix |
|---------|---------|-----|
| **Silos** | Disconnected experiences between departments | End-to-end journey owners |
| **Inside-out** | Designed around internal process, not customer need | Outside-in redesign |
| **Channel conflict** | Different experience per channel | Unified experience standards |
| **Dead ends** | No clear next step | Explicit handoffs and CTAs |
| **Assumption-based** | Map without customer input | Research-validated journeys |

## Journey Metrics by Stage

| Stage | Primary Metric | Secondary |
|-------|----------------|-----------|
| Awareness | Reach, brand recall | Traffic sources |
| Consideration | Engagement, time on site | Comparison page views |
| Purchase | Conversion rate | Cart abandonment |
| Onboarding | Time to first value | Completion rate |
| Usage | Feature adoption | Support ticket volume |
| Advocacy | NPS, referral rate | Review sentiment |
