# Employee Experience

## The EX-CX Connection

Employee experience directly impacts customer experience:
- **Happy employees** → Better service → Higher CSAT
- **Empowered employees** → Faster resolution → Lower CES
- **Engaged employees** → Genuine care → Higher NPS
- **Burned out employees** → Defensive service → Churn

Research consistently shows: companies with top EX scores outperform on CX metrics.

## Employee Journey Mapping

Apply the same journey thinking to employees:

### Key Employee Moments
| Stage | Moments That Matter |
|-------|---------------------|
| **Recruit** | Job posting, interviews, offer experience |
| **Onboard** | First day, first week, first win |
| **Develop** | Feedback, training, growth opportunities |
| **Perform** | Recognition, support, tools |
| **Transition** | Promotion, role change, exit |

### Frontline-Specific Journey
For customer-facing roles, add:
- **Tool readiness** — Do they have what they need?
- **Knowledge access** — Can they find answers fast?
- **Authority clarity** — What can they decide?
- **Escalation paths** — Who to call when stuck?
- **Recovery support** — Backup when overwhelmed?

## Employee Experience Metrics

### eNPS (Employee Net Promoter Score)
- "Would you recommend this company as a place to work?"
- Same 0-10 scale, same calculation as customer NPS
- Correlates strongly with retention and CX performance

### Additional EX Metrics
| Metric | What It Measures |
|--------|------------------|
| Engagement score | Discretionary effort, commitment |
| Enablement score | Tools, resources, support |
| Manager effectiveness | Leadership quality |
| Growth perception | Development opportunities |
| Recognition frequency | Appreciation culture |

## Empowerment Framework

### Decision Authority Matrix
| Decision Type | Authority Level | Examples |
|---------------|-----------------|----------|
| **Standard** | Any agent | Refunds under $X, shipping upgrades |
| **Elevated** | Team lead | Larger refunds, policy exceptions |
| **Escalated** | Manager | Contract changes, major credits |
| **Executive** | Director+ | Legal issues, PR risk |

### Empowerment Enables
- Faster resolution → Lower CES
- Employee confidence → Better interactions
- Reduced escalations → Lower cost to serve
- Customer trust → "They actually helped me"

## Voice of Employee Program

### Feedback Channels
1. **Pulse surveys** — Quick, frequent (weekly/biweekly)
2. **Engagement surveys** — Comprehensive, quarterly
3. **Stay interviews** — Why people stay
4. **Exit interviews** — Why people leave
5. **Frontline feedback** — Direct input on customer issues

### Key Questions for Frontline
- "What customer problems can't you solve?"
- "What tools would make your job easier?"
- "What policy frustrates customers most?"
- "What do customers compliment?"
- "What would you change if you could?"

## Culture Alignment

### CX Culture Elements
- **Customer obsession** — Decisions start with customer impact
- **Ownership** — Problems are mine until solved
- **Transparency** — Honest about limitations
- **Continuous learning** — Feedback is gift, not threat
- **Collaboration** — Cross-functional for customer outcomes

### Reinforcement Mechanisms
- **Hiring** — Select for empathy and ownership
- **Onboarding** — Immerse in customer stories
- **Recognition** — Celebrate CX wins publicly
- **Metrics** — Include CX in performance reviews
- **Stories** — Share customer impact regularly

## Warning Signs

EX problems that predict CX decline:
- Rising absenteeism
- Increased turnover (especially tenure)
- Declining engagement scores
- More escalations
- Frontline cynicism
- "Not my job" language
- Tool/system complaints
