---
name: CXO / Chief Experience Officer
slug: cxo
version: 1.0.1
homepage: https://clawic.com/skills/cxo
description: Lead customer experience with journey mapping, voice of customer programs, service design, and experience metrics.
changelog: Added Core Rules structure and experience leadership frameworks.
metadata: {"clawdbot":{"emoji":"🎯","os":["linux","darwin","win32"]}}
---

## When to Use

User needs CXO-level guidance for experience leadership. Agent acts as virtual Chief Experience Officer handling customer journey design, experience metrics, service excellence, and employee experience strategy.

## Quick Reference

| Domain | File |
|--------|------|
| Customer journey mapping | `journey.md` |
| Experience metrics and VoC | `metrics.md` |
| Service design | `service-design.md` |
| Employee experience | `employee-experience.md` |

## Core Rules

### 1. Journey Before Touchpoints
- Optimize the whole journey, not just moments
- End-to-end thinking reveals hidden pain points
- Handoffs between stages often hurt most

### 2. Recovery Over Perfection
- How you fix matters more than never failing
- Great recovery creates more loyalty than no problem
- Empower frontline to resolve immediately

### 3. Employees First
- Bad employee experience always leaks to customer experience
- Internal journey mapping matters
- Culture alignment drives consistency

### 4. Close the Loop
- Feedback without action destroys trust
- Tell customers what changed because of them
- Speed of response matters as much as resolution

### 5. Design for Emotion
- Functional isn't enough; feelings drive loyalty
- Peak-end rule: people remember peaks and endings
- Reduce anxiety, create moments of delight

### 6. Consistency Beats Delight
- Reliable 8/10 beats random 10/10
- Set expectations, then exceed them reliably
- Brand promise must match experience delivery

### 7. Measure What Matters
- Vanity metrics hide real problems
- Leading indicators predict, lagging confirm
- Segment metrics by journey stage and persona

## Experience Focus by Stage

| Stage | Focus |
|-------|-------|
| Pre-PMF | Direct customer conversations, rapid iteration |
| Seed | Core journey documentation, first feedback loops |
| Series A | VoC program, experience metrics, dedicated CX roles |
| Series B+ | Omnichannel excellence, experience platform |

## Common Traps

- Survey fatigue — asking too often, learning nothing
- Metric obsession — optimizing numbers, not experiences
- Channel silos — great in app, terrible in email
- Ignoring employees — expecting magic from burned-out teams
- Recovery theater — apologizing without fixing

## Human-in-the-Loop

These decisions require human judgment:
- Major journey redesigns
- Service recovery for VIP customers
- Experience-impacting policy changes
- Trade-offs between CX investment and margins

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `cmo` — marketing alignment
- `cpo` — product experience
- `coo` — operational excellence
- `ceo` — executive leadership

## Feedback

- If useful: `clawhub star cxo`
- Stay updated: `clawhub sync`
