---
name: CV
description: Create ATS-optimized resumes and CVs with proper structure, metrics, and industry targeting.
metadata: {"clawdbot":{"emoji":"📄","requires":{},"os":["linux","darwin","win32"]}}
---

## Resume vs CV

| Aspect | Resume | CV |
|--------|--------|-----|
| Length | 1-2 pages max | No limit (can be 10+ pages) |
| Purpose | Snapshot tailored to job | Complete academic/professional history |
| Use | Industry jobs (US, Canada) | Academia, research, medicine, EU jobs |
| Update | Customize per application | Add new achievements continuously |

Use **resume** for: tech companies, startups, corporate jobs, when posting says "resume"
Use **CV** for: academic positions, research roles, EU/UK applications, grants and fellowships

## Structure

**Order for experienced professionals:**
1. Contact Info
2. Professional Summary
3. Work Experience
4. Skills
5. Education

**Order for recent graduates:**
1. Contact Info
2. Professional Summary
3. Education
4. Skills
5. Projects/Internships

**Never include:** Photo (US jobs), birth date, marital status, religion, full address (city + state only), "References available upon request"

## Professional Summary

Formula:
```
[Title] with [X years] of [domain] experience. 
[Key achievement with metrics]. 
Skilled in [top 3 relevant skills]. Seeking to [goal] at [company type].
```

Example:
```
Senior Software Engineer with 7 years of backend experience. 
Reduced API latency by 40% serving 2M daily users at scale. 
Expert in Python, AWS, and distributed systems. 
Seeking to lead platform engineering at a growth-stage fintech.
```

Avoid objective statements ("Seeking a position where I can grow...")—they're outdated and self-focused.

## Experience Bullets

**CAR Formula:** Action Verb + Task + Result with Metrics

```
❌ Responsible for managing the engineering team
✅ Led 8-person engineering team, delivering 3 major features 2 weeks ahead of schedule

❌ Helped improve sales
✅ Increased enterprise sales by $2.3M (34% YoY) through automated lead scoring

❌ Worked on the checkout system
✅ Reduced checkout abandonment from 68% to 41% by redesigning 3-step flow
```

**Action verbs by category:**
| Leadership | Technical | Growth | Efficiency |
|------------|-----------|--------|------------|
| Led, Directed | Developed, Architected | Increased, Grew | Reduced, Streamlined |
| Managed, Mentored | Engineered, Built | Expanded, Generated | Automated, Optimized |

Limit 3-5 bullets per role. Start with strongest achievement.

## Quantification

Every bullet should have numbers when possible:

| Vague | Quantified |
|-------|------------|
| Managed a team | Managed team of 12 across 3 time zones |
| Improved performance | Reduced load time from 4s to 800ms |
| Increased revenue | Generated $1.2M ARR from new product line |
| Handled support | Resolved 50+ tickets/week with 98% satisfaction |

Types of metrics: revenue ($), percentage (%), time saved, team size, users/customers, scale (requests/sec), satisfaction scores

## ATS Optimization

75% of resumes never reach human eyes due to ATS filtering.

**Do:**
- Standard section headers: "Work Experience", "Education", "Skills"
- Both acronym AND full version: "AWS (Amazon Web Services)"
- Keywords from job description, naturally integrated
- Standard fonts: Arial, Calibri, Times New Roman (10pt minimum)
- PDF with selectable text (not scanned image)

**Don't:**
- Tables, columns, or text boxes—ATS can't parse them
- Headers/footers with important info—ATS may skip them
- Images, logos, or graphics
- Creative headers: "My Journey" → "Experience"
- Special symbols (✓, ➤)—use standard bullets (•, -)
- Keyword stuffing—triggers spam filters

## Tech Industry

**Must include:**
- GitHub profile URL
- Technical skills categorized (Languages, Frameworks, Cloud, Tools)
- Projects with live links
- Scale metrics (users, requests/sec, data volume)

**Skills format:**
```
Languages: Python, TypeScript, Go
Frameworks: React, FastAPI, Django
Cloud: AWS (EC2, Lambda, S3), GCP
Tools: Docker, Kubernetes, Terraform, GitHub Actions
```

**Avoid:** Obsolete tech (jQuery, Flash), "Proficient in Microsoft Office", vague titles ("Code Ninja")

## Design Industry

**Must include:**
- Portfolio link (prominent, first line after name)
- Tools: Figma, Sketch, Adobe CC
- Process: user research, wireframing, prototyping, usability testing
- Impact metrics: conversion rates, user satisfaction scores

**Avoid:** Resume without portfolio link (instant rejection), listing only tools without methodology

## Length Guidelines

| Experience | Length |
|------------|--------|
| Student / Entry-level | 1 page |
| 1-5 years | 1 page |
| 5-10 years | 1-2 pages |
| 10+ years / Executive | 2 pages max |
| Academic CV | No limit |

For senior roles, condense early-career positions to 1-2 lines.

## Common Mistakes

- Listing responsibilities instead of achievements—shows what you did, not impact
- Starting bullets with "Responsible for..."—passive voice, no impact
- No metrics—impossible to gauge value delivered
- Same resume for every job—ATS matches keywords to job description
- Typos and grammar errors—instant rejection at many companies
- Unprofessional email (cooldude99@...)—use firstname.lastname@
- Including photo in US applications—bias concerns, often auto-rejected
- PDF from image/scan—ATS can't extract text
- More than 2 pages—recruiters spend 6-7 seconds on first scan
- First-person pronouns ("I managed...")—remove, start with verbs

## Pre-Submit Checklist

```
□ Professional email address
□ Summary tailored to target role
□ 70%+ of bullets include metrics
□ Skills match job description keywords
□ Acronyms + full versions (SEO + Search Engine Optimization)
□ Consistent formatting throughout
□ 1-2 pages maximum
□ Text-selectable PDF
□ Filename: FirstName_LastName_Resume.pdf
□ LinkedIn matches resume content
□ No tables, columns, or text boxes
□ No typos (use spell check + human review)
```
