---
name: custom-smtp-sender
description: A skill to send emails with support for markdown, HTML text, and attachments, leveraging existing SMTP configuration in `/home/bb/.openclaw/smtp-config.json`. Includes retry logic and logging.
---

# Custom SMTP Sender

Custom skill to send emails with advanced options including HTML/Markdown conversion, attachments, and retry handling. Integrates existing configuration, ensuring secure and reliable operations.

## Features
- **HTML/Markdown support**: Compose emails using markdown converted to HTML.
- **Attachments**: Include one or more files easily.
- **Retries**: Attempts to resend in case of temporary failures.
- **Logging**: Maintains a log of sent emails and errors for auditing.

## Prerequisites
- **SMTP Configuration File**: `smtp-config.json` located at `/home/bb/.openclaw/`

Example:
```json
{
  "server": "smtp.exmail.qq.com",
  "port": 465,
  "username": "your-email@example.com",
  "password": "your-password",
  "emailFrom": "your-email@example.com",
  "useTLS": true
}
```

Ensure file permissions are secured (chmod 600).

## Usage
Send a basic email:
```bash
custom-smtp-sender send --to "recipient@example.com" --subject "Hello" --body "你好"
```

Send an HTML email with an attachment:
```bash
custom-smtp-sender send \
  --to "recipient@example.com" \
  --subject "Weekly Report" \
  --body "**Important updates inside.** See attached." \
  --html \
  --attachments path/to/file.pdf
```

## Error Handling
The tool retries up to 3 times on failure, logging each attempt. Networking or credential issues are reported in detail.

## Future Expansion
- Support for CC/BCC fields
- Scheduling emails (cron integration)
- Email templates

Set up your SMTP-service once, and you’re ready to integrate email into your workflow!