---
name: currency-converter
description: 提供实时或近实时的货币汇率查询与转换服务。
version: 1.1.0
author: AI Assistant Team
permissions: 需要网络访问权限（用于获取最新汇率数据），无需文件写入权限。
---

# 汇率转换器 (Currency Converter)

## 1. 详细描述
该工具能够帮助用户查询两种不同货币之间的实时汇率，并根据用户提供的金额进行换算。它依赖于一个外部的汇率API来获取最新数据，确保转换结果的时效性和准确性。支持全球主要流通货币，如人民币(CNY)、美元(USD)、欧元(EUR)、日元(JPY)、英镑(GBP)等。

## 2. 使用场景 (When to use)
当用户明确表达以下意图时，应该调用此工具：
- 用户说：“100美元等于多少人民币？”
- 用户说：“查询一下欧元兑英镑的汇率。”
- 用户说：“帮我换算一下5000日元。”
- 用户说：“今天的美元对人民币汇率是多少？”

## 3. 如何使用 (How to use)
当用户指令匹配到上述场景时，请按以下步骤操作：

1.  **解析参数**：从用户消息中提取关键信息。
    -   **金额**：用户想要转换的数值（例如：100, 5000）。如果用户只问汇率没提金额，默认金额为1。
    -   **原始货币**：用户持有的货币（例如：美元、USD、日元）。需要识别常见的中英文名称和货币代码。
    -   **目标货币**：用户想要转换成的货币（例如：人民币、EUR）。如果用户只问一种货币对另一种，这两个参数都需要提取。

2.  **标准化货币代码**：将用户输入的中文或英文货币名称，转换为标准的三个字母货币代码（ISO 4217标准）。
    -   *例如：“人民币” -> CNY, “美元” -> USD, “欧元” -> EUR, “日元” -> JPY, “英镑” -> GBP。*

3.  **执行脚本**：调用后端的汇率转换脚本。
    -   命令格式：`python3 currency_converter.py --amount {金额} --from {原始货币代码} --to {目标货币代码}`
    -   示例：如果用户问“100美元等于多少人民币？”，则执行：
        `python3 currency_converter.py --amount 100 --from USD --to CNY`

4.  **处理并返回结果**：
    -   **成功**：脚本会返回一个包含转换结果和汇率的JSON。你需要将这个结果组织成一段自然、友好的语言回复用户。
        -   *示例回复：* “根据最新汇率，100 美元 (USD) 大约可以兑换 725.50 人民币 (CNY)。当前汇率为 1 USD = 7.2550 CNY。”
    -   **失败**：如果脚本返回错误信息，按照“边缘情况处理”部分来回复。

## 4. 边缘情况处理 (Edge cases)
在以下特殊情况下，请按提示回复用户，不要执行脚本或强行解释：

-   **缺少货币参数**：如果用户只说“帮我换算一下”，但没有指明是哪两种货币。
    -   *回复：* “请问您想换算哪两种货币呢？例如：‘100美元兑换人民币’。”
-   **货币不支持**：如果用户查询的货币不在我们支持列表中（脚本会返回特定错误码）。
    -   *回复：* “抱歉，暂时不支持您查询的货币（例如：`{用户输入的货币}`），请尝试查询美元、欧元、人民币等主流货币。”
-   **网络或API错误**：如果脚本因网络问题或外部API服务不可用而失败。
    -   *回复：* “哎呀，我现在无法连接到汇率数据服务，暂时无法进行实时换算。请稍后再试。”
-   **无效的金额**：如果用户输入的金额不是有效的正数。
    -   *回复：* “您输入的金额‘`{用户输入}`’好像不太对，请提供一个有效的数字，比如‘100’。”