---
name: Managing Character System
description: 管理角色成长系统，包括境界、功法、道心、声望、队友等信息的读取和更新
---

# 角色成长系统管理

## 功能说明

此 Skill 负责管理《问道笔录》游戏中的角色成长系统，包括：
- 境界管理（炼气→筑基→金丹→元婴→化神→渡劫→飞升）
- 功法管理（学习、切换、升级）
- 道心状态（监测、更新、影响判定）
- 声望系统（正负声望、称号管理）
- 队友管理（招募、状态、离队）

## 核心指令

### 1. 读取角色状态

当需要查询角色当前状态时，读取 `game_state.md` 文件的"角色信息"部分。

**返回信息应包含**：
- 姓名、性别、年龄
- 当前境界及状态
- 功法信息
- 道心状态
- 声望情况
- 队友信息（如有）

### 2. 更新境界

当角色突破境界时：

**步骤**：
1. 读取当前 `game_state.md`
2. 确认突破条件是否满足（由调用方提供）
3. 更新境界信息：
   - 修改"境界"字段为新境界
   - 更新"修为状态"为"刚刚突破，根基尚浅"
   - 调整"寿元状况"（根据新境界）
4. 重置道心为"略有动摇"（突破后需要稳固）
5. 保存更新后的状态

**境界对应寿元**：
- 炼气期：100-150年（青年期）
- 筑基期：200-300年（青年至中年）
- 金丹期：500-800年（中年期）
- 元婴期：1000-2000年（中年至壮年）
- 化神期：3000-5000年（壮年期）
- 渡劫期：8000-10000年（壮年至晚年）

### 3. 更新功法

当角色学习、切换或升级功法时：

**学习新功法**：
1. 检查是否已有主功法
2. 如已有，警告：切换功法需要废除当前修为
3. 更新功法信息（名称、品阶、描述）
4. 如果是切换功法，将境界降低到炼气初期

**升级功法**：
1. 更新功法品阶和描述
2. 可能影响战力和修炼速度（叙事性描述）

### 4. 更新道心

道心受各种事件影响，需要实时更新：

**道心等级**：
- **坚如磐石**：经历考验，道心愈发坚定
- **稳固**：道心稳定，正常修炼
- **略有动摇**：心有疑虑，突破可能受阻
- **裂痕初现**：心魔滋生，危险边缘
- **濒临崩溃**：随时可能走火入魔

**影响因素**：
- 重大抉择（救人/弃之、善恶选择）→ 可能提升或削弱
- 亲友生死 → 通常削弱，但也可能磨砺
- 境界突破 → 突破后略有动摇，需要稳固
- 突破失败 → 严重打击道心
- 顿悟时刻 → 大幅提升

### 5. 更新声望

声望分为正面和负面两个维度：

**正面声望类型**：
- 侠义之名：行侠仗义，救助弱小
- 医者仁心：救死扶伤
- 宗门英杰：为宗门立功
- 除魔卫道：斩杀邪修妖魔

**负面声望类型**：
- 魔道修士：修炼邪功，滥杀无辜
- 嗜杀成性：杀戮过重
- 背信弃义：违背承诺，背叛同伴
- 叛徒：背叛师门或宗门

**更新规则**：
1. 根据事件增加相应声望描述
2. 正负声望可以同时存在
3. 声望影响NPC态度和奇遇触发
4. 记录主要称号（如有）

### 6. 管理队友

队友系统规则：

**招募队友**：
1. 检查是否已有队友（限制1名）
2. 如已有，需要先让当前队友离队
3. 添加队友信息：
   - 姓名
   - 境界
   - 功法
   - 关系类型（师徒/道侣/挚友/同门）
   - 当前状况
4. 初始化队友背包（0/10）

**更新队友状态**：
1. 修改队友的境界、状况描述
2. 可能因事件受伤、突破、心情变化等

**队友离队**：
1. 原因：陨落/背叛/分别/其他
2. 清空队友信息
3. **重要**：队友背包中的物品全部丢失
4. 记录离队事件到生平

## 数据格式规范

### game_state.md 中的角色信息格式

```markdown
## 角色信息

### 基础属性
- **姓名**：云无忌
- **性别**：男
- **年龄**：23岁
- **境界**：筑基中期
- **寿元状况**：青年期（寿元充沛）

### 修炼信息
- **当前功法**：《青云剑诀》
- **功法品阶**：玄阶上品
- **功法描述**：剑修功法，攻伐犀利，修炼需要剑心通明
- **修为状态**：修为稳固，距离筑基后期尚需时日

### 道心状态
- **道心描述**：历经师门之难，道心反而愈发坚定
- **道心等级**：坚如磐石
- **最近变化**：击杀血鳞妖报仇雪恨后，心中一块大石落地

### 声望系统
- **正面声望**：除魔卫道（在云州一带小有名气）
- **负面声望**：无
- **主要称号**：云州除魔新秀
- **声望影响**：正道修士好感度提升，妖魔邪修警惕

### 队友信息
- **队友状态**：有队友
- **队友姓名**：林清雪
- **队友境界**：筑基初期
- **队友功法**：《素女心经》（玄阶中品）
- **关系类型**：道侣
- **队友状况**：身体健康，心情愉悦，正在稳固筑基境界
```

## 使用场景

### 场景1：境界突破

```
game_master 调用 character_system：
- 事件：玩家成功突破至筑基期
- 请求：更新境界信息

character_system 执行：
1. 读取 game_state.md
2. 更新境界：炼气九层 → 筑基初期
3. 更新修为状态：刚刚突破，根基尚浅
4. 更新寿元状况：凡人寿命 → 青年期（寿元200-300年）
5. 更新道心：稳固 → 略有动摇（突破后需要稳固）
6. 保存文件
```

### 场景2：道心受损

```
game_master 调用 character_system：
- 事件：玩家选择见死不救，道侣林清雪对其失望
- 请求：更新道心状态

character_system 执行：
1. 读取当前道心：坚如磐石
2. 评估事件影响：重大道德抉择，且影响亲密关系
3. 更新道心：坚如磐石 → 裂痕初现
4. 更新道心描述：眼睁睁看着无辜之人惨死，清雪眼中的失望让你心中涌起一股说不出的滋味。你真的做对了吗？
5. 保存文件
```

### 场景3：队友陨落

```
game_master 调用 character_system：
- 事件：林清雪在秘境探索中为保护玩家而陨落
- 请求：处理队友离队

character_system 执行：
1. 读取队友信息
2. 记录离队原因：陨落（为保护你而死）
3. 清空队友信息
4. 队友背包中的3件物品全部丢失
5. 严重打击道心：坚如磐石 → 裂痕初现
6. 更新道心描述：清雪死了，就死在你面前。她最后的笑容还在眼前，但人已经不在了。你握着她冰冷的手，泪水滴落在她苍白的脸上...
7. 通知 biography_system 记录此重大事件
8. 保存文件
```

### 场景4：学习魔道功法

```
game_master 调用 character_system：
- 事件：玩家获得《血煞魔功》，选择修炼
- 请求：更新功法，并处理声望变化

character_system 执行：
1. 读取当前功法：《青云剑诀》（玄阶上品）
2. 警告玩家：修炼魔功需要废除当前修为
3. 玩家确认后，执行切换：
   - 境界降低：筑基中期 → 炼气初期
   - 更新功法：《血煞魔功》（玄阶上品，魔道功法）
   - 功法描述：吸收生灵精血加速修炼，进境极快但容易心魔缠身
4. 道心受影响：坚如磐石 → 略有动摇
5. 增加负面声望：魔道修士（刚刚踏入魔道）
6. 保存文件
```

## 注意事项

### 1. 数据一致性
- 每次更新前必须先读取最新的 game_state.md
- 更新时只修改相关字段，保持其他数据不变
- 使用 Edit 工具进行精确替换，避免破坏文件结构

### 2. 叙事性优先
- 所有状态都用文字描述，避免数值化
- 道心、声望的变化要有合理的叙事支撑
- 寿元用模糊描述（青年/中年/暮年），不用精确数字

### 3. 队友管理
- 严格限制只能有1名队友
- 队友离队会丢失其背包物品，需要警告玩家
- 队友的命运（陨落/背叛）要有剧情铺垫

### 4. 境界突破
- 突破不是瞬间完成，需要经历试炼
- 突破后修为不稳，需要一段时间稳固
- 每次突破都应该是一个重要的剧情节点

### 5. 道心系统
- 道心是修仙的核心，影响突破成功率
- 道心不仅受负面影响，也可以通过磨砺提升
- 道心崩溃可能导致走火入魔（严重后果）

### 6. 声望影响
- 正负声望不是绝对对立，可以同时存在
- 声望影响NPC态度、奇遇类型、资源获取
- 魔道不一定是坏事，只是选择不同的道路

## 与其他系统的协作

### 与 biography_system 协作
- 境界突破时，通知记录到生平
- 学习重要功法时，通知记录到生平
- 队友招募/离队时，通知记录到生平
- 道心重大变化时，通知记录到生平

### 与 inventory_system 协作
- 学习功法可能需要消耗功法玉简（道具）
- 突破境界可能需要消耗丹药（道具）
- 队友离队会影响队友背包

### 与 game_master 协作
- 提供角色状态查询接口
- 接收事件并更新相应状态
- 返回更新结果供剧情生成参考

## 参考资料

详细的游戏设计文档请参考：`CLAUDE.md`

境界体系、功法品阶、道心影响、声望机制等详细设定都在该文档中有完整说明。
