---
name: Managing Biography System
description: 管理生平记录系统，记录玩家经历的重大事件，用1-2句话概括每个事件
---

# 生平记录系统管理

## 功能说明

此 Skill 负责管理《问道笔录》游戏中的生平记录系统，包括：
- 记录重大事件（境界突破、生死抉择、情感羁绊等）
- 生成简洁吸引人的事件描述（1-2句话）
- 管理前世传承信息
- 提供生平回顾和分享功能

## 核心指令

### 1. 查询生平

读取 `game_state.md` 文件的"生平回顾"部分。

**返回信息应包含**：
- 前世传承（如有）
- 本世经历的所有重大事件（按时间顺序）
- 事件总数

### 2. 添加生平事件

当发生重大事件时：

**步骤**：
1. 读取当前生平记录
2. 根据事件类型和内容，生成1-2句话的简洁描述
3. 添加到生平列表末尾（按时间顺序）
4. 保存文件

**事件描述原则**：
- **简洁**：1-2句话，不超过50字
- **有重点**：突出事件的关键信息
- **吸引人**：用词精炼，引发共鸣
- **连贯性**：与之前事件形成连续的人生轨迹

### 3. 更新前世传承

在游戏开局时（ch00_start），如果是新周目：

**步骤**：
1. 读取上一世的生平总结
2. 记录选择的传承类型（功法/法宝/笔录）
3. 生成传承描述
4. 保存到新周目的生平开头

### 4. 生成生平总结

在飞升时（ch07_ascension），生成本世总结：

**步骤**：
1. 读取完整生平记录
2. 提炼本世最重要的3-5个事件
3. 生成简洁的一生总结（2-3句话）
4. 返回给 ch07_ascension 用于传承选择

## 重大事件类型

### 1. 境界突破类
- 首次引气入体
- 炼气、筑基、金丹、元婴、化神、渡劫各阶突破
- 突破失败的重大挫折

**示例**：
- "十六岁引气入体，踏上修仙路"
- "闭关百日，九死一生方才筑基成功"
- "金丹破碎，修为倒退，险些身死道消"

### 2. 生离死别类
- 师父/亲人/挚友陨落
- 道侣离别或背叛
- 师门覆灭
- 队友牺牲

**示例**：
- "妖兽攻山，眼睁睁看着师父为保护弟子而亡"
- "清雪死了，就死在我面前，为保护我而死"
- "师门一夜覆灭，唯我一人侥幸逃生"
- "与青梅竹马的师妹分别，此生再未相见"

### 3. 重大抉择类
- 善恶抉择（救人/见死不救）
- 道路选择（正道/魔道）
- 舍得抉择（放弃宝物救人）
- 复仇抉择（报仇/放下）

**示例**：
- "面对无辜村民被屠，选择挺身而出，虽重伤但无悔"
- "为求突破，修炼血煞魔功，从此踏入魔道"
- "用仅有的筑基丹救活母亲，错过突破良机"
- "百年修行，终于手刃血鳞妖，为师父报仇雪恨"

### 4. 情感羁绊类
- 结识挚友/道侣
- 收徒/拜师
- 结为异姓兄弟
- 爱情萌芽

**示例**：
- "在落霞峰遇见素衣女修林清雪，一见倾心"
- "与流浪少年云飞结拜为兄弟，此生不负"
- "收下孤儿小白为徒，传他剑法，盼他有成"
- "师父临终前将毕生所学传给我，泣不成声"

### 5. 奇遇机缘类
- 获得重要功法/法宝
- 发现上古传承
- 进入秘境
- 得遇高人指点

**示例**：
- "探索上古剑冢，获得《青云剑诀》进阶法门"
- "误入仙人洞府，得传承天阶功法《五雷正法》"
- "在生死边缘顿悟剑意，实力大进"
- "偶遇化神大能，得其一语点拨，茅塞顿开"

### 6. 劫难考验类
- 天劫考验
- 心魔劫
- 仇家追杀
- 绝境求生

**示例**：
- "渡元婴天劫，九死一生，肉身几乎崩溃"
- "心魔劫中见到所有死去之人，险些道心崩溃"
- "被魔道修士追杀三千里，断臂逃生"
- "身陷绝地，以残躯斩杀化神妖兽，声名大震"

### 7. 成就荣誉类
- 获得称号
- 声名远扬
- 创立宗门
- 收徒传道

**示例**：
- "一剑斩杀三名金丹邪修，被誉为云州除魔新秀"
- "创立青云剑宗，传剑道于世"
- "千年岁月，收徒三百，桃李满天下"

## 生平记录格式

### game_state.md 中的生平格式

```markdown
## 生平回顾

### 前世传承
· 携带《青云剑诀》玉简转世重修

### 本世经历
· 十六岁引气入体，踏上修仙路
· 妖兽攻山，眼睁睁看着师父为保护弟子而亡
· 苦修三年，终于击杀血鳞妖，为师父报仇雪恨
· 闭关百日，九死一生方才筑基成功
· 在落霞峰遇见素衣女修林清雪，一见倾心
· 与清雪结为道侣，在师门见证下结缘
· 探索上古剑冢，获得《青云剑诀》进阶法门
· 清雪为保护我而死在秘境中，从此心中留下永远的痛
```

## 使用场景

### 场景1：境界突破

```
character_system 或 game_master 调用 biography_system：
- 事件：玩家成功筑基
- 请求：添加生平事件

biography_system 执行：
1. 读取当前生平
2. 分析事件：首次筑基，重要里程碑
3. 检查上下文：之前有"苦修三年"的记录
4. 生成描述："闭关百日，九死一生方才筑基成功"
5. 添加到生平列表
6. 保存文件
```

### 场景2：师父牺牲

```
game_master 调用 biography_system：
- 事件：妖兽攻击宗门，师父为保护弟子们牺牲
- 详情：
  - 师父名字：云岚真人
  - 玩家境界：炼气五层
  - 情感：痛苦、愧疚、无力
- 请求：添加生平事件

biography_system 执行：
1. 读取当前生平
2. 分析事件：生离死别类，师父牺牲，对玩家影响深远
3. 提炼关键：妖兽攻山、师父之死、保护弟子
4. 生成描述："妖兽攻山，眼睁睁看着师父为保护弟子而亡"
5. 添加到生平列表
6. 保存文件
```

### 场景3：道侣之缘

```
game_master 调用 biography_system：
- 事件：玩家与林清雪在落霞峰初次相遇，一见倾心
- 请求：添加生平事件

biography_system 执行：
1. 生成描述："在落霞峰遇见素衣女修林清雪，一见倾心"
2. 添加到生平
3. 保存文件

后续调用：
- 事件：与林清雪结为道侣
- 生成描述："与清雪结为道侣，在师门见证下结缘"
- 添加到生平
```

### 场景4：重大抉择

```
game_master 调用 biography_system：
- 事件：玩家用仅有的筑基丹救活病危的母亲，放弃自己突破
- 详情：
  - 选择：舍己为人
  - 代价：错过突破良机
  - 情感：孝道、矛盾、无悔
- 请求：添加生平事件

biography_system 执行：
1. 分析抉择类事件
2. 提炼关键：筑基丹、救母亲、错过突破
3. 生成描述："用仅有的筑基丹救活母亲，错过突破良机"
4. 添加到生平
5. 保存文件
```

### 场景5：新周目开始（前世传承）

```
ch07_ascension 调用 biography_system：
- 事件：玩家飞升成功
- 生平总结：一生经历百年，从凡人到飞升，历经磨难
- 选择传承：《青云剑诀》玉简
- 请求：生成传承记录

biography_system 执行：
1. 生成传承描述："携带《青云剑诀》玉简转世重修"
2. 返回给 ch07_ascension

ch00_start 调用 biography_system：
- 事件：新周目开始
- 传承信息：《青云剑诀》玉简
- 请求：初始化新生平

biography_system 执行：
1. 清空本世经历
2. 设置前世传承：
   ### 前世传承
   · 携带《青云剑诀》玉简转世重修

   ### 本世经历
   *新的一生即将开始*
3. 保存文件
```

### 场景6：生成生平总结（飞升时）

```
ch07_ascension 调用 biography_system：
- 请求：生成生平总结

biography_system 执行：
1. 读取完整生平：
   · 十六岁引气入体，踏上修仙路
   · 妖兽攻山，眼睁睁看着师父为保护弟子而亡
   · 苦修三年，终于击杀血鳞妖，为师父报仇雪恨
   · 闭关百日，九死一生方才筑基成功
   · 在落霞峰遇见素衣女修林清雪，一见倾心
   · 与清雪结为道侣，在师门见证下结缘
   · 探索上古剑冢，获得《青云剑诀》进阶法门
   · 清雪为保护我而死在秘境中，从此心中留下永远的痛
   （...更多事件...）
   · 渡过九九天劫，破碎虚空，飞升上界

2. 提炼关键事件：
   - 师父之死（起点）
   - 道侣之缘与道侣之死（情感主线）
   - 复仇成功（执念）
   - 飞升成功（终点）

3. 生成总结：
   "此生百年，始于师父之死，执剑修道，虽得道侣却终生离死别。复仇雪恨后，踏上剑道巅峰，终破虚空飞升。"

4. 返回给 ch07_ascension 用于展示
```

## 注意事项

### 1. 事件筛选原则

**应该记录的事件**：
- 境界突破（每个大境界必记）
- 重要人物的生死（师父、道侣、挚友）
- 重大道德抉择
- 关键机缘和奇遇
- 决定性的战斗
- 人生转折点

**不应记录的事件**：
- 日常修炼（除非有特殊意义）
- 普通的购买交易
- 无关紧要的对话
- 重复性的活动
- 过于琐碎的细节

### 2. 描述风格要求

**优秀示例**：
- "妖兽攻山，眼睁睁看着师父为保护弟子而亡"
  - 简洁、画面感强、情感浓烈

- "在落霞峰遇见素衣女修林清雪，一见倾心"
  - 地点、人物、感情，三要素齐全

- "闭关百日，九死一生方才筑基成功"
  - 时间、困难、结果，层次分明

**糟糕示例**（避免）：
- "我今天修炼了一整天，然后成功筑基了"
  - 流水账，无重点

- "师父死了，我很伤心，然后我发誓要报仇，后来我真的报仇成功了"
  - 啰嗦，应该拆分成多个事件

- "获得了很厉害的功法"
  - 太模糊，缺少具体信息

### 3. 时间线连贯性

生平事件应该形成连贯的人生轨迹：
- 事件之间有因果关系
- 情感变化有脉络可循
- 境界成长符合逻辑
- 人物关系发展自然

### 4. 前世传承的处理

- 首次游玩：无前世传承
- 新周目：必须有前世传承
- 传承类型：功法/法宝/笔录三选一
- 传承描述应简洁且有纪念意义

### 5. 生平长度控制

- 每个周目建议记录15-30个重大事件
- 如果事件过多，可以合并相似事件
- 保持生平的可读性，不要过长

### 6. 情感共鸣

生平描述要能引发玩家共鸣：
- 师父之死 → 痛苦、愧疚、成长
- 道侣相遇 → 温暖、希望、甜蜜
- 复仇成功 → 释然、空虚、迷茫
- 飞升时刻 → 成就、孤独、超脱

## 与其他系统的协作

### 与 character_system 协作
- 境界突破时 → 添加生平事件
- 队友招募/离队时 → 添加生平事件
- 道心重大变化时 → 添加生平事件
- 学习重要功法时 → 添加生平事件

### 与 inventory_system 协作
- 获得重要道具时 → 添加生平事件
- 失去珍贵道具时 → 添加生平事件

### 与 game_master 协作
- 每个重大剧情节点 → 添加生平事件
- 重大抉择后 → 添加生平事件
- 战斗胜利/失败 → 酌情添加生平事件

### 与 ch07_ascension 协作
- 飞升时 → 生成生平总结
- 选择传承后 → 保存传承信息

### 与 ch00_start 协作
- 新周目开始 → 初始化生平，添加前世传承

## 生平事件示例库

### 炼气期事件
- "十六岁引气入体，踏上修仙路"
- "资质平庸，引气入体比同门晚了三年"
- "师父见我勤奋，传我基础剑法"
- "第一次使用术法，激动得彻夜难眠"

### 筑基期事件
- "闭关百日，九死一生方才筑基成功"
- "筑基失败，道基破碎，修为倒退"
- "筑基成功后，寿元大增，亲眼看着父母老去"
- "第一次御剑飞行，俯瞰大地，心中激荡"

### 金丹期事件
- "结丹之劫，引来天雷，险些形神俱灭"
- "金丹成，寿元五百载，从此告别凡尘"
- "同门师兄结丹失败陨落，心有戚戚"
- "神识外放，感知方圆百里，如临仙境"

### 元婴期事件
- "金丹化婴，元婴初成，窥见长生之路"
- "渡元婴天劫，肉身毁去大半，元婴遁走"
- "夺舍重生，保住性命，但心中愧疚难安"
- "千年修行，故人凋零殆尽，唯剩孤身一人"

### 化神期事件
- "元婴化神，神魂合一，举手投足引动天地之力"
- "参悟雷之法则，领悟一丝天道真意"
- "创立宗门，传道于世，收徒百人"
- "三千年岁月，见证沧海桑田，人间已无牵挂"

### 渡劫期事件
- "渡九九天劫第一重，天雷洗礼，痛不欲生"
- "天劫第五重，道心险些崩溃，最终咬牙坚持"
- "了结因果，诛杀仇家，心中再无执念"
- "万载修行，回首来路，初心是否还在？"

### 飞升事件
- "渡过九九天劫，破碎虚空，飞升上界"
- "飞升前，选择传承《青云剑诀》给后世"
- "飞升前，在师门刻下传承石碑，留法宝予有缘人"
- "飞升前，写下修炼心得，盼后人少走弯路"

## 参考资料

详细的游戏设计文档请参考：`CLAUDE.md`

生平系统、重大事件定义、叙事风格等详细设定都在该文档中有完整说明。
