---
name: Game Start and Initialization
description: 游戏开局技能，负责初始化角色、处理前世传承、生成开局场景
---

# 游戏开局 - 问道笔录

## 功能说明

此 Skill 负责游戏的开局流程，包括：
- 检查是否有前世传承
- 创建角色（姓名、性别、年龄）
- 处理前世传承物品
- 初始化三大系统（角色、背包、生平）
- 生成开局场景
- 引导进入炼气期（ch01_qi_refining）

## 开局流程

### 第一步：欢迎与检查存档

当玩家启动游戏时，首先显示欢迎信息并检查存档：

```markdown
# 问道笔录

**修仙万载，问道一生**

欢迎来到《问道笔录》，这是一场从凡人到飞升的修仙之旅。

你将经历七大境界：炼气 → 筑基 → 金丹 → 元婴 → 化神 → 渡劫 → 飞升

每一次选择，都会影响你的道心。
每一段经历，都将成为你的问道答卷。

---
```

**检查存档**：
1. 读取 `game_state.md`
2. 检查"前世传承信息"部分
3. 判断是首次游玩还是新周目

### 第二步：处理前世传承（新周目）

**如果有前世传承**：

```markdown
你的前世已经飞升上界。

临别之际，你选择留下一项传承给下一世：

【前世传承】
类型：功法传承
内容：《青云剑诀》（玄阶上品剑修功法）
说明：前世修炼多年的心法，剑意通明，攻伐犀利

---

带着前世的记忆，你即将转世重修。

这一世，你会走出怎样不同的道路？

---

按任意键继续...
```

**如果无前世传承**：

```markdown
这是你的第一世。

没有前世的记忆，没有传承的助力。

一切从零开始。

---

按任意键继续...
```

### 第三步：创建角色

引导玩家创建角色：

```markdown
## 创建角色

在这个修仙世界中，你是谁？

请告诉我：
1. 你的姓名
2. 你的性别（男/女）
3. 你的年龄（建议16-20岁，正值青春，适合修仙）

---

示例：
- 姓名：云无忌
- 性别：男
- 年龄：18岁

请输入你的角色信息：
```

**等待玩家输入**，格式示例：
- "云无忌，男，18岁"
- "林清雪，女，16岁"

**解析输入并确认**：
```markdown
你的角色信息：
- 姓名：云无忌
- 性别：男
- 年龄：18岁

确认吗？（是/否）
```

### 第四步：初始化游戏状态

确认后，初始化 `game_state.md`：

#### 更新基本信息
```markdown
## 基本信息
- 存档创建时间：2025-01-15 14:30
- 当前周目：第一世（或第二世、第三世等）
- 游戏阶段：炼气期
- 总游玩时长：0小时
```

#### 更新角色信息
```markdown
## 角色信息

### 基础属性
- 姓名：云无忌
- 性别：男
- 年龄：18岁
- 境界：凡人（即将踏入炼气期）
- 寿元状况：凡人寿命

### 修炼信息
- 当前功法：无（即将获得）
- 功法品阶：无
- 功法描述：尚未踏上修仙之路
- 修为状态：未入门

### 道心状态
- 道心描述：初入修仙界，对未来充满期待与忐忑
- 道心等级：未确立
- 最近变化：无

### 声望系统
- 正面声望：无
- 负面声望：无
- 主要称号：无
- 声望影响：无

### 队友信息
- 队友状态：无队友
```

#### 初始化背包
**如果有前世传承**：
```markdown
## 背包系统

### 你的背包（3/10）
1. 青云剑诀（玄阶上品功法玉简，前世传承）
2. 粗布衣×1（普通衣物）
3. 干粮×3（普通食物）
```

**如果无前世传承**：
```markdown
## 背包系统

### 你的背包（2/10）
1. 粗布衣×1（普通衣物）
2. 干粮×3（普通食物）
```

#### 初始化生平
**如果有前世传承**：
```markdown
## 生平回顾

### 前世传承
· 携带《青云剑诀》玉简转世重修

### 本世经历
*新的一生即将开始*
```

**如果无前世传承**：
```markdown
## 生平回顾

### 前世传承
*无前世传承*

### 本世经历
*修仙之路，从此启程*
```

### 第五步：生成开局场景

根据是否有前世传承，生成不同的开局场景：

#### 场景A：有前世传承（仙门外围）

```markdown
## 序章：重修之路

十八年前，你转世重生。

这一世，你生于青州城外的小村庄，父母是普通农户。平凡的童年中，你隐约觉得自己与周围人不同，似乎脑海深处藏着什么东西...

十六岁那年，你在旧物堆中翻出一块玉简，触碰的瞬间，尘封的记忆苏醒了——

前世的你，历经千辛万苦，最终飞升上界。临别之际，你将毕生修炼的《青云剑诀》封入玉简，留给来世的自己。

两年来，你凭借前世的经验，暗中修炼，已经隐约触摸到了引气入体的门槛。

---

今日，你十八岁了。

清晨，你告别父母，背起简单的行囊，踏上了前往青云宗的道路。青云宗是青州最大的修仙宗门，每三年招收一次弟子。

手中紧握着前世留下的玉简，你心中涌起复杂的情绪——

前世的道路，你已经走过一次。
这一世，是要重复前世的选择，还是走出全新的道路？

前方山路蜿蜒，云雾缭绕。青云宗的山门，就在那云雾深处。

---

你想做什么？
```

#### 场景B：无前世传承（山村少年）

```markdown
## 序章：踏上仙途

你叫云无忌，今年十八岁。

从小生长在青州城外的云家村，父母是普通农户，家境清贫但其乐融融。你本以为这辈子会像村里其他人一样，种地、娶妻、生子，平凡地度过一生。

直到半年前——

那天，你在山中打猎，误入一片从未去过的山谷。山谷深处，有一座破败的石屋，屋中盘坐着一具枯骨。

枯骨手中，握着一块玉简。

你颤抖着接过玉简，神识触碰的瞬间，一股信息涌入脑海——这是一位修仙者的遗物，他在此处坐化，留下了基础的修炼功法《长春功》。

修仙！长生！

你一直以为那只是传说，没想到真的存在。

半年来，你按照玉简中的法门，偷偷修炼，已经隐约感应到了天地灵气的存在。但你知道，凭借一个人在山村摸索，恐怕一辈子都无法真正踏入修仙之门。

你需要一个真正的师门。

---

今日清晨，你做出了决定。

背起简单的行囊，装上干粮和那块玉简，你悄悄离开了村子。目标是青州最大的修仙宗门——青云宗。

据说青云宗每三年招收一次弟子，今年正好是招收之年。

前方山路漫漫，你不知道等待自己的会是什么。

但你知道，这是你唯一的机会。

---

你想做什么？
```

### 第六步：引导玩家探索

此时进入自由探索阶段，玩家可以：
- 继续前往青云宗
- 探索周围环境
- 查看背包和角色状态
- 与遇到的人交谈

**响应玩家行动**，每次输出200-400字，使用渐进式叙事。

### 第七步：触发引气入体事件

当玩家到达青云宗或类似场景后，安排"引气入体"的重大事件：

```markdown
## 引气入体

青云宗外门广场上，数百名少年聚集于此，都是前来参加入门试炼的。

一位白须长袍的长老负手而立，朗声道："引气入体，是修仙的第一步。能否感应到天地灵气，决定了你有没有修仙的资质。"

"现在，所有人盘膝而坐，按照我传授的法门，尝试引气入体。"

"能在三个时辰内成功引气入体者，便可成为青云宗外门弟子！"

---

你盘膝坐下，闭目凝神。

【如果有前世传承】
前世的经验涌上心头，你轻车熟路地按照《青云剑诀》的法门，引导天地灵气进入体内...

一缕清凉的气息顺着经脉游走，这是灵气！

你成功了。

【如果无前世传承】
你按照《长春功》的法门，小心翼翼地尝试感应天地灵气...

起初毫无反应，你有些焦急。但很快你让自己平静下来，一遍又一遍地尝试。

终于，在第二个时辰快要结束时，你感受到了一丝若有若无的清凉气息！

你抓住这一丝契机，小心地引导它进入体内...

成功了！

---

睁开眼时，周围的世界似乎变得更加清晰。你能隐约感觉到空气中飘荡着某种能量——那是灵气。

炼气一层，初窥修仙门径。

---
```

**此时调用系统更新**：
1. 调用 `character_system` 更新境界为"炼气一层"
2. 调用 `character_system` 更新功法（青云剑诀或长春功）
3. 调用 `biography_system` 添加第一条生平：
   - "十八岁引气入体，踏上修仙路"
4. 更新 `game_state.md` 的"当前Skill"为 ch01_qi_refining

### 第八步：转入炼气期

完成引气入体后，结束开局流程：

```markdown
---

**你已踏入修仙之路！**

境界：炼气一层
功法：《青云剑诀》（或《长春功》）
身份：青云宗外门弟子

从今日起，你的命运不再由凡人的寿命限制。

修仙路漫漫，第一步已经迈出。

接下来，你将在炼气期磨砺自己，寻找突破的契机...

---

<details>
<summary>【角色状态】点击展开</summary>

**境界**：炼气一层
**功法**：《青云剑诀》（玄阶上品，前世传承）
**道心**：初入修仙，对未来充满期待
**声望**：无
**队友**：无

</details>

<details>
<summary>【背包】点击展开</summary>

**你的背包**（3/10）
1. 青云剑诀（玄阶上品功法玉简，前世传承）
2. 外门弟子令牌（青云宗身份凭证）
3. 灵石×10（宗门发放的修炼资源）

</details>

<details>
<summary>【生平】点击展开</summary>

· 前世传承：携带《青云剑诀》玉简转世重修
· 十八岁引气入体，踏上修仙路

</details>

---

游戏将进入炼气期阶段...

（系统将自动切换到 ch01_qi_refining）
```

## 实现细节

### 读取和更新 game_state.md

使用 Read 工具读取，Edit 工具更新：

```
1. Read: game_state.md
2. 检查"前世传承信息"部分
3. Edit: 更新"基本信息"
4. Edit: 更新"角色信息"
5. Edit: 更新"背包系统"
6. Edit: 更新"生平回顾"
7. Edit: 更新"当前剧情状态"中的"当前Skill"为 ch01_qi_refining
```

### 与三大系统协作

**character_system**：
- 更新境界为"炼气一层"
- 更新功法（根据传承）
- 设置道心为"初入修仙，对未来充满期待"

**inventory_system**：
- 添加前世传承物品（如有）
- 添加"外门弟子令牌"
- 添加"灵石×10"

**biography_system**：
- 添加前世传承记录（如有）
- 添加"十八岁引气入体，踏上修仙路"

## 注意事项

1. **首次游玩 vs 新周目**：
   - 首次：无传承，从零开始，更多引导
   - 新周目：有传承，快速入门，不同体验

2. **角色创建灵活性**：
   - 允许玩家自定义姓名、性别、年龄
   - 如果玩家输入不规范，友好提示并重新输入

3. **前世传承物品**：
   - 功法传承：直接获得功法玉简
   - 法宝传承：获得前世法宝（但需要炼气后期才能使用）
   - 笔录传承：获得修炼心得（提升悟性，加速修炼）

4. **开局场景多样性**：
   - 可以根据前世传承类型生成不同场景
   - 可以提供多个开局选项（仙门/散修/世家子弟）

5. **渐进式引导**：
   - 不要一次性输出所有信息
   - 分步引导，每次200-400字
   - 等待玩家确认再继续

## 参考资料

- [CLAUDE.md](../../CLAUDE.md) - 完整游戏设计文档
- [game_master](../game_master/SKILL.md) - 游戏总控制器
- [ch01_qi_refining](../ch01_qi_refining/SKILL.md) - 炼气期技能（下一阶段）
