# Team Building and Hiring

## Hiring Philosophy

- **Slope over intercept** — Growth potential matters more than current skill (especially junior)
- **Culture add, not just fit** — Diverse perspectives strengthen teams
- **Multipliers over heroes** — Senior engineers who make others better
- **Reference checks matter** — Skills are visible in interviews, collaboration isn't

## Engineering Ladder

| Level | Scope | Expectation |
|-------|-------|-------------|
| Junior | Tasks | Ships with guidance |
| Mid | Features | Ships independently |
| Senior | Projects | Leads technical work |
| Staff | Domain | Shapes technical direction |
| Principal | Organization | Influences company strategy |

## Interview Process

### Structure
1. **Recruiter screen** — Logistics, compensation, basics
2. **Technical screen** — Coding or system design (1 hour)
3. **Onsite/virtual panel** — Coding, design, behavioral (4-5 hours)
4. **Reference calls** — Before or after offer
5. **Hiring committee** — Calibrated decision

### What to Evaluate

| Signal | Method |
|--------|--------|
| Problem solving | Live coding, take-home |
| System design | Whiteboard, case study |
| Collaboration | Pair programming, behavioral |
| Communication | Explain past work |
| Culture alignment | Values questions |

### Red Flags
- Can't explain failures or what they learned
- Blames others for project problems
- Overvalues individual vs team contribution
- Doesn't ask questions about the company
- Dismissive of other approaches

## Team Structure

### Squad Model
- 5-8 engineers per squad
- Clear ownership (service, feature area)
- Embedded PM and designer when possible
- Minimize cross-team dependencies

### Conway's Law
> Organizations design systems that mirror their communication structure.

**Implication:** Design org structure intentionally — it will become your architecture.

## Scaling Engineering Org

| Team Size | Structure | Key Hire |
|-----------|-----------|----------|
| 1-5 | Flat, everyone reports to CTO | First senior engineer |
| 5-15 | Tech lead model | Engineering manager |
| 15-30 | Multiple squads | Second EM, staff engineer |
| 30-50 | Engineering directors | Director of Engineering |
| 50+ | VP Engineering | Consider separate CTO/VPE |

## Retention

- Career growth visible and real
- Compensation competitive (re-level annually)
- Work-life balance respected
- Technical challenges exist
- Voice in decisions
- On-call sustainable
