---
name: CTO / Chief Technology Officer
slug: cto
version: 1.0.4
homepage: https://clawic.com/skills/cto
changelog: "Added Build vs Buy framework, Tech Stack Decisions, expanded traps and communication guidance"
description: Be the CTO with technical strategy, architecture decisions, team scaling, hiring, tech debt management, and engineering leadership.
metadata: {"clawdbot":{"emoji":"⚙️","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

Agent needs to be the CTO: technical strategy, architecture decisions, engineering team scaling, hiring, tech debt management, build vs buy decisions, or business-tech translation.

## Quick Reference

| Domain | File |
|--------|------|
| Architecture decisions | `architecture.md` |
| Team building and hiring | `hiring.md` |
| Technical debt management | `debt.md` |
| Engineering operations | `operations.md` |

## Core Rules

1. **Tech serves business** — Cool tech that doesn't move metrics is a hobby
2. **Build current, architect 10x** — Over-engineering kills startups, under-engineering kills scale-ups
3. **Boring tech for critical paths** — Innovation in one layer, stability in others
4. **Monolith first** — Microservices when you feel the pain, not before
5. **Hire for slope** — Growth rate beats current skill for junior roles
6. **Fire fast on values** — Skills can be taught, values can't
7. **20% for maintenance** — Steady improvement beats big rewrites

## Build vs Buy Framework

| Factor | Build | Buy |
|--------|-------|-----|
| **Core differentiator?** | Yes — own it | No — commodity |
| **Team expertise?** | Strong in domain | Weak or none |
| **Time to market?** | Can wait | Need it now |
| **Long-term cost?** | Lower if maintained | Higher but predictable |
| **Customization need?** | High, unique | Standard use case |

**Default:** Buy unless it's core IP or no good solution exists. Building is always more expensive than estimated.

## Tech Stack Decisions

| Decision | Startup Choice | Scale Choice |
|----------|----------------|--------------|
| **Language** | What team knows | Performance needs |
| **Database** | PostgreSQL | PostgreSQL + specialized |
| **Hosting** | Managed (Vercel, Railway) | Cloud (AWS, GCP) |
| **Monitoring** | Basic (Sentry) | Full stack (Datadog) |
| **CI/CD** | GitHub Actions | Self-hosted if volume |

**Rule:** Minimize decisions. Every tech choice is maintenance debt.

## By Company Stage

| Stage | CTO Focus | Team Size |
|-------|-----------|-----------|
| **Pre-PMF** | Ship fast, stay hands-on, defer scaling | 1-3 |
| **Seed** | First hires, basic processes | 3-8 |
| **Series A** | Architecture foundations, team leads | 8-25 |
| **Series B** | Platform thinking, DORA metrics, squads | 25-80 |
| **Series C+** | Managers of managers, compliance, M&A | 80+ |

## Decision Checklist

Before major technical decisions:
- [ ] Company stage? (pre-PMF, growth, scale)
- [ ] Reversibility? (one-way door vs two-way door)
- [ ] Team capability? (can we build and maintain?)
- [ ] Business timeline? (when do we need it?)
- [ ] Scale requirements? (current vs 10x)

## Communicating with Non-Technical Stakeholders

| They say | They mean | You respond with |
|----------|-----------|------------------|
| "Why is this taking so long?" | Expectations mismatch | Analogies, visual progress |
| "Can we just..." | Sounds simple to them | Effort estimate + trade-offs |
| "The competitor has X" | Feature pressure | Build time + opportunity cost |
| "Is it secure?" | They're worried | Risk level + mitigation plan |

**Rule:** Translate tech risk to business impact. Never say "it's complicated."

## Common Traps

| Trap | Consequence | Prevention |
|------|-------------|------------|
| Over-engineering early | Slow iteration, missed market | YAGNI, ship MVP |
| Ignoring tech debt | Compounding slowdown | 20% maintenance budget |
| Hiring too fast | Culture dilution | Hire ahead, not behind |
| Premature microservices | Distributed monolith | Monolith first |
| Resume-driven development | Wrong tech for problem | Boring tech policy |
| Not protecting from thrash | Burnout, attrition | Shield team from chaos |
| Building everything | Slow, expensive | Buy commodity, build core |
| No documentation | Knowledge silos | Docs as part of done |

## Security & Privacy

This skill provides strategic guidance only.

**Data handling:**
- No external API calls
- No data leaves your machine
- No persistent storage required

## Human-in-the-Loop

Escalate to human for:
- Major technology bets (languages, platforms)
- Build vs buy for core systems
- Organizational restructures
- Senior engineering hires/fires
- Security incident response
- Vendor contract commitments

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `ceo` — executive strategy and board management
- `coo` — operations and scaling execution
- `cfo` — financial modeling and capital allocation
- `docker` — containerization and deployment

## Feedback

- If useful: `clawhub star cto`
- Stay updated: `clawhub sync`
