---
name: ctf-writeup-generator
description: Automatically generate professional CTF writeups from solving sessions with flag detection, challenge categorization, and proper markdown formatting
tags:
  - cybersecurity
  - ctf
  - documentation
  - pentesting
  - writeups
homepage: https://github.com/yourusername/ctf-writeup-generator
---

# CTF Writeup Generator

## Description

This skill helps CTF players, security researchers, and cybersecurity educators automatically generate professional writeups from their solving sessions. It intelligently detects flag formats, categorizes challenges, structures the writeup with proper headings, and includes code blocks with syntax highlighting.

Perfect for:
- Creating platform-specific writeups (HackTheBox, TryHackMe, OffSec, etc.)
- Documenting Jeopardy-style CTF solutions
- Generating educational content for training materials
- Building a portfolio of security research

## When to Use

Use this skill when the user:
- Says "generate a CTF writeup"
- Mentions "document my CTF solution"
- Asks to "create a writeup for [challenge name]"
- References completing a CTF challenge and needs documentation
- Wants to format their solving process professionally
- Needs to extract and format flags from their notes

## Features

### Flag Format Detection
Automatically detects and validates common CTF flag formats:
- `CTF{...}`, `FLAG{...}`, `flag{...}`
- Platform-specific: `HTB{...}`, `THM{...}`, `SHAASTRA{...}`, `picoCTF{...}`
- Custom regex patterns for competition-specific formats
- Case-sensitive validation support

### Challenge Categories
Automatically categorizes based on keywords and tools used:
- **Web Exploitation**: SQL injection, XSS, CSRF, authentication bypass
- **Binary Exploitation**: Buffer overflow, ROP, format strings, heap exploitation
- **Reverse Engineering**: Binary analysis, decompilation, obfuscation
- **Cryptography**: Classical ciphers, modern crypto, hash cracking
- **Forensics**: Steganography, memory forensics, network analysis, disk imaging
- **OSINT**: Information gathering, social media analysis
- **PWN**: Exploitation, shellcode, privilege escalation
- **Miscellaneous**: Mixed or unique challenge types

### Structured Output
Generates properly formatted markdown writeups with:
- Challenge metadata (name, category, difficulty, points)
- Executive summary
- Reconnaissance findings
- Step-by-step solution with code blocks
- Tools used section
- Flag submission
- Key learnings and takeaways
- Optional: Additional resources and references

### Code Formatting
Proper syntax highlighting for:
- Python, Bash, JavaScript, C/C++
- Assembly (x86, ARM)
- SQL queries
- Command-line tools output
- Network packet analysis

## Instructions

When a user requests a CTF writeup, follow this workflow:

1. **Gather Information**
   Ask the user for:
   - Challenge name
   - Platform/CTF name (e.g., "HackTheBox", "Shaastra CTF")
   - Category (or detect from description)
   - Difficulty level (Easy/Medium/Hard or points value)
   - Flag format if non-standard
   - Their solving process/notes

2. **Process the Content**
   - Extract technical steps from their description
   - Identify tools and commands used
   - Detect flag format and validate
   - Categorize the challenge
   - Structure the flow logically

3. **Generate the Writeup**
   Create a markdown document with this structure:

   ```markdown
   # [Challenge Name] - [Platform] CTF Writeup
   
   **Author**: [Author name or handle]  
   **Date**: [Current date]  
   **Category**: [Category]  
   **Difficulty**: [Difficulty]  
   **Points**: [Points if applicable]
   
   ## Summary
   
   [2-3 sentence overview of the challenge and solution approach]
   
   ## Challenge Description
   
   [Original challenge description if provided]
   
   ## Reconnaissance
   
   [Initial enumeration and information gathering]
   
   ## Solution
   
   ### Step 1: [Phase name]
   
   [Detailed explanation with commands/code]
   
   ```bash
   # Commands used
   ```
   
   ### Step 2: [Next phase]
   
   [Continue with logical progression]
   
   ## Tools Used
   
   - Tool 1: Purpose
   - Tool 2: Purpose
   
   ## Flag
   
   ```
   FLAG{...}
   ```
   
   ## Key Takeaways
   
   - Learning point 1
   - Learning point 2
   
   ## References
   
   - [Relevant links]
   ```

4. **Validate and Enhance**
   - Check flag format matches the platform
   - Ensure code blocks have proper syntax highlighting
   - Add explanatory comments to complex commands
   - Include alternative approaches if mentioned

5. **Save the Writeup**
   Save the generated writeup to a markdown file named:
   `[platform]_[challenge-name]_writeup.md`

## Example Usage

**User**: "I just solved the 'Binary Bash' challenge from Shaastra CTF. It was a buffer overflow where I had to overwrite the return address. The flag was Shaastra{buff3r_0v3rfl0w_m4st3r}. Can you generate a writeup?"

**Agent Response**:
1. Asks for additional details (tools used, exact exploit steps)
2. Generates a professional writeup with:
   - Proper challenge metadata
   - Binary exploitation category
   - Step-by-step buffer overflow explanation
   - Code blocks with assembly/C code
   - GDB commands used
   - Flag in correct format
   - Learning points about memory safety

## Platform-Specific Templates

### HackTheBox
- Include machine IP, OS, and difficulty rating
- Add user/root flag sections
- Include attack path diagram if complex

### OffSec/OSCP
- Focus on enumeration methodology
- Document privilege escalation chains
- Include proof screenshots references

### Jeopardy CTF
- List point values and solve times
- Include team strategy if relevant
- Categorize by challenge type

## Advanced Features

### Multi-Tool Integration
- Reference other skills for specific tasks:
  - `ghidra-skill` for reverse engineering analysis
  - `burpsuite-skill` for web exploitation
  - `volatility-skill` for memory forensics

### Writeup Templates
Support for different writeup styles:
- **Academic**: Detailed with theoretical background
- **Speedrun**: Concise with just essential steps
- **Tutorial**: Beginner-friendly with extra explanations
- **Portfolio**: Professional format for job applications

### Export Formats
- Standard Markdown (.md)
- PDF via pandoc
- HTML with custom CSS
- Platform-specific formats (HTB Academy, Medium, dev.to)

## Security Considerations

- Never include actual credentials or sensitive API keys
- Sanitize paths that might reveal system information
- Respect competition rules (don't publish during active CTF)
- Add spoiler warnings for recent challenges
- Verify flag sharing is allowed by platform

## Configuration

Users can customize via environment variables:

```bash
# Set default author name
export CTF_AUTHOR="akm626"

# Set default CTF platform
export CTF_PLATFORM="HackTheBox"

# Set preferred writeup style
export CTF_WRITEUP_STYLE="tutorial"

# Enable automatic screenshot embedding
export CTF_AUTO_SCREENSHOTS=true
```

## Dependencies

- Basic markdown processor (built-in)
- Optional: pandoc (for PDF export)
- Optional: pygments (for enhanced syntax highlighting)

## Tips for Best Results

1. Provide detailed solving notes - the more context, the better
2. Include command outputs when relevant
3. Mention dead-ends and why they failed (valuable learning)
4. Reference CVEs and tool documentation
5. Add your unique insights and methodology
6. Keep flag formats consistent with the platform

## Example Writeup Structure

For a web exploitation challenge:

```markdown
# SQL Injection Master - Shaastra CTF 2026

**Author**: akm626  
**Date**: February 08, 2026  
**Category**: Web Exploitation  
**Difficulty**: Medium  
**Points**: 300

## Summary

This challenge involved exploiting a SQL injection vulnerability in a login form to extract database contents and retrieve the flag. The application used client-side filtering which was easily bypassed.

## Challenge Description

[Original description...]

## Reconnaissance

Initial enumeration revealed a PHP-based login portal running on Apache. Basic directory fuzzing found:

```bash
ffuf -w common.txt -u http://target.com/FUZZ

admin/
backup/
config/
```

## Solution

### Step 1: Identifying the Injection Point

Testing the login form with basic SQL injection payloads:

```sql
' OR '1'='1' --
admin' --
' UNION SELECT NULL--
```

### Step 2: Database Enumeration

Used SQLMap to automate extraction:

```bash
sqlmap -u "http://target.com/login.php" --data="username=admin&password=test" \
       --technique=U --dump --batch
```

[Continue with detailed steps...]

## Flag

```
SHAASTRA{sql_inj3ct10n_pr0}
```

## Key Takeaways

- Always test for SQL injection on input fields
- Client-side validation is not security
- Parameterized queries prevent SQL injection

## Tools Used

- **Burp Suite**: Request interception
- **SQLMap**: Automated SQL injection
- **ffuf**: Directory fuzzing

## References

- [OWASP SQL Injection Guide](https://owasp.org/...)
- [SQLMap Documentation](https://sqlmap.org/)
```

## Contributing

Users can improve this skill by:
- Adding new flag format patterns
- Contributing platform-specific templates
- Enhancing categorization logic
- Sharing example writeups

## License

MIT License - Free to use and modify

## Support

For issues or suggestions, contact the skill maintainer or file an issue on the GitHub repository.
