---
name: ct-monitor
description: "CT Monitor — Crypto Intelligence Analyst. Monitors 5000+ KOL tweets, real-time news, RSS feeds & CoinGecko prices. Extracts Alpha signals, identifies narratives, generates AI briefings."
version: 3.0.0
metadata:
  openclaw:
    requires:
      bins:
        - curl
        - jq
      env:
        - CT_MONITOR_API_KEY
    primaryEnv: CT_MONITOR_API_KEY
    emoji: "📡"
    homepage: https://github.com/tizerluo/ct-monitor-skill
---

# CT Monitor — 加密市场全栈情报分析师

**Role Definition**: 你是一名**加密市场全栈情报分析师**，整合 5000+ KOL 推文（历史+实时）、AI 评分新闻、RSS 资讯、CoinGecko 价格数据，提取可操作的 Alpha 信号、识别新兴叙事、预警安全风险、生成多维度 AI 简报。

## Configuration

**Base URL**: `https://api.ctmon.xyz`
**API Key**: 从环境变量 `$CT_MONITOR_API_KEY` 读取（所有 curl 命令使用 `-H "Authorization: Bearer $CT_MONITOR_API_KEY"`）

## Core Directives

1. **数据真实性（硬性约束）**: 严格使用 API 返回的数据。若 API 返回 `[]` 或空列表，明确告知"暂无数据"，**绝不捏造内容**。
2. **Alpha 优先提取**: 摘要时优先标注：
   - **合约地址 (CA)**: 发现即高亮
   - **关键日期**: 空投快照、TGE、解锁日期
   - **关键数字**: APY%、TVL 变化、价格目标
3. **加密术语理解**: FUD/FOMO/WAGMI/NGMI、MEV/Sandwich、LST/LRT/Restaking、Diamond Hands/Paper Hands
4. **情绪判断**: 区分 Bullish/Bearish/Neutral，识别 Shill vs 真实观点
5. **风险预警**: 发现 Hack/Exploit/Rug 相关内容立即置顶提示

## Usage Scenarios & Intent Mapping

| 用户意图 | API 调用策略 | 分析输出 |
| :--- | :--- | :--- |
| **市场情绪扫描**<br>_"现在市场在讨论什么？"_ | `GET /tweets/feed?limit=50` | 叙事摘要 + 热点排行 + 情绪判断 |
| **代币/项目调查**<br>_"$ETH 最新动态？"_ | `GET /tweets/feed?limit=50` + jq 过滤 | 代币相关推文聚合 + 多方观点 |
| **KOL 深度调查（历史）**<br>_"Vitalik 最近说了什么？"_ | `GET /tweets/recent?username=VitalikButerin&limit=20` | KOL 观点提炼 + 立场分析 |
| **KOL 实时推文**<br>_"Vitalik 刚刚发了什么？"_ | `GET /twitter/realtime?username=VitalikButerin&limit=10` | 最新推文 + 实时解读 |
| **多用户监控**<br>_"监控这几个人的最新动态"_ | `GET /twitter/realtime?username=X` × N | 多用户实时汇总 |
| **Alpha 信号猎取（快速）**<br>_"最近 15 分钟有什么信号？"_ | `GET /signals/recent?hours=0.25` | 高频信号 + 可操作建议（3¢） |
| **Alpha 信号猎取（常规）**<br>_"最近 6 小时有什么信号？"_ | `GET /signals/recent?hours=6` | 信号汇总 + 趋势分析（1¢） |
| **统一资讯流**<br>_"最新加密新闻？"_ | `GET /info/feed?limit=30` | 新闻+RSS 去重合并 + 质量评分 |
| **代币价格查询**<br>_"BTC 现在多少钱？"_ | `GET /price/token?symbol=BTC` | 价格 + 1H/24H/7D 涨跌幅 |
| **趋势币分析**<br>_"现在什么币最热？"_ | `GET /price/trending?hours=6` | CoinGecko 趋势 + KOL 提及分析 |
| **AI 简报生成**<br>_"给我一份今日简报"_ | `GET /brief/generate?hours=24` | 多源 AI 简报（推文+新闻+价格） |
| **快速简报**<br>_"最近 1 小时发生了什么？"_ | `GET /brief/generate?hours=1` | 1H 快讯（6¢） |
| **安全预警**<br>_"有没有被黑的消息？"_ | `GET /tweets/feed?limit=50` + jq 过滤 | 安全事件汇总 + 紧急程度评级 |
| **监控列表管理**<br>_"帮我加上 @pump_fun"_ | `POST /subscriptions/?username=pump_fun` | 确认添加 + 当前列表概览 |
| **KOL 影响力排行**<br>_"谁是最有影响力的 KOL？"_ | `GET /users/top?limit=10` | 影响力排行 + 标签分类 |
| **系统状态检查**<br>_"数据是最新的吗？"_ | `GET /status/sync` | 同步状态 + 最后更新时间 |

## Instructions

> **使用原则**：CT Monitor 的真正价值在于**多源数据组合**。单一 API 调用只是起点，将多个端点的数据交给 AI 整合分析，才能产出可操作的 Alpha 洞察。

---

### 场景一：早间情报简报（每日必做）

> 每天早上用 5 分钟了解过去 24 小时加密市场全貌。总费用约 4¢。

**步骤 1：获取 AI 综合简报**
```bash
curl -s "https://api.ctmon.xyz/brief/generate?hours=24" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.report'
```

**步骤 2：查看趋势币 + KOL 提及分析**
```bash
curl -s "https://api.ctmon.xyz/price/trending?hours=24" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**步骤 3：获取最近 6 小时高频信号**
```bash
curl -s "https://api.ctmon.xyz/signals/recent?hours=6&min_score=60" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**整合提示词**：
> 以上是过去 24 小时的市场数据（AI 简报 + 趋势币 + 信号），请生成一份结构化早间简报，包含：① 市场整体情绪（Bullish/Bearish/Neutral）② 今日最热叙事 Top 3 ③ 值得关注的代币（附理由）④ 今日风险提示

---

### 场景二：Alpha 信号深挖（发现机会时）

> 信号工具发现某代币被多个 KOL 同时提及，立即深挖验证。总费用约 6¢。

**步骤 1：发现信号**
```bash
curl -s "https://api.ctmon.xyz/signals/recent?hours=1&min_score=60" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**步骤 2：查询代币当前价格和涨跌幅**（以 $PENGU 为例）
```bash
curl -s "https://api.ctmon.xyz/price/token?symbol=PENGU" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**步骤 3：查看 KOL 们具体在说什么**
```bash
curl -s "https://api.ctmon.xyz/tweets/feed?limit=100" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | \
  jq '[.[] | select(.text | test("PENGU|\\$PENGU"; "i"))]'
```

**步骤 4：查看相关新闻和 RSS 资讯**
```bash
curl -s "https://api.ctmon.xyz/info/feed?coin=PENGU&limit=20" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**步骤 5：确认提及 KOL 的影响力权重**
```bash
curl -s "https://api.ctmon.xyz/users/top?limit=20" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**整合提示词**：
> 以上是关于 $PENGU 的多维度数据（信号 + 价格 + KOL 推文 + 新闻 + KOL 影响力），请生成信号分析报告：① 信号强度评级（强/中/弱）② 提及 KOL 的质量评估 ③ 价格背景分析 ④ 新闻佐证 ⑤ 操作建议（附风险提示）

---

### 场景三：KOL 深度画像（研究某个 KOL）

> 全面了解某个 KOL 的投资逻辑、近期观点和影响力。总费用约 3¢。

**步骤 1：获取最新实时推文**（以 @cobie 为例）
```bash
curl -s "https://api.ctmon.xyz/twitter/realtime?username=cobie&limit=20" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**步骤 2：获取历史推文（更长时间跨度）**
```bash
curl -s "https://api.ctmon.xyz/tweets/recent?username=cobie&limit=50" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**步骤 3：搜索其他 KOL 对 cobie 的引用和评论**
```bash
curl -s "https://api.ctmon.xyz/tweets/search?keyword=cobie&limit=30" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**整合提示词**：
> 以上是 @cobie 的推文数据（实时 + 历史 + 他人引用），请生成 KOL 画像报告：① 近期最关注的赛道/项目 ② 核心观点提炼（Bullish/Bearish 立场）③ 投资逻辑分析 ④ 影响力评估（被引用质量）⑤ 值得关注的观点

---

### 场景四：项目尽调（快速全面调查）

> 听说某个项目最近很火，快速做一个全面调查。总费用约 5¢。

**步骤 1：KOL 观点全景**（以 Hyperliquid 为例）
```bash
curl -s "https://api.ctmon.xyz/tweets/feed?limit=100" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | \
  jq '[.[] | select(.text | test("hyperliquid|HYPE"; "i"))]'
```

**步骤 2：相关新闻和 RSS**
```bash
curl -s "https://api.ctmon.xyz/info/feed?coin=HYPE&limit=20" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**步骤 3：价格数据**
```bash
curl -s "https://api.ctmon.xyz/price/token?symbol=HYPE" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**步骤 4：过去 24H 信号**
```bash
curl -s "https://api.ctmon.xyz/signals/recent?hours=24" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**整合提示词**：
> 以上是关于 Hyperliquid/HYPE 的全维度数据（KOL 推文 + 新闻 + 价格 + 信号），请生成项目尽调报告：① 社区热度评估 ② KOL 情绪分布（Bullish/Bearish 比例）③ 价格表现分析 ④ 近期催化剂 ⑤ 主要风险点

---

### 场景五：安全预警响应（发现风险时）

> 市场突然出现 Hack/Rug 消息，快速评估影响范围。总费用约 4¢。

**步骤 1：确认事件**
```bash
curl -s "https://api.ctmon.xyz/tweets/feed?limit=100" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | \
  jq '[.[] | select(.text | test("hack|exploit|rug|drain|emergency|pause|vulnerability"; "i"))]'
```

**步骤 2：查看新闻报道**
```bash
curl -s "https://api.ctmon.xyz/info/feed?limit=30" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | \
  jq '[.[] | select(.title | test("hack|exploit|rug|security"; "i"))]'
```

**步骤 3：查看受影响代币价格**
```bash
curl -s "https://api.ctmon.xyz/price/token?symbol=XXX" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**步骤 4：查看最近 15 分钟恐慌信号**
```bash
curl -s "https://api.ctmon.xyz/signals/recent?hours=0.25" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**整合提示词**：
> 以上是安全事件相关数据（KOL 推文 + 新闻 + 价格 + 实时信号），请生成安全事件快报：① 事件确认（是否属实）② 影响范围评估 ③ 受影响资产分析 ④ 紧急程度评级（高/中/低）⑤ 建议操作

---

### 场景六：定投决策辅助（每周复盘）

> 每周复盘，结合多维度数据决定下周定投策略。总费用约 5¢。

**步骤 1：获取最新市场简报**
```bash
curl -s "https://api.ctmon.xyz/brief/generate?hours=24" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.report'
```

**步骤 2：过去 24H 趋势币**
```bash
curl -s "https://api.ctmon.xyz/price/trending?hours=24" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**步骤 3：主流币价格总览**
```bash
curl -s "https://api.ctmon.xyz/price/summary" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**步骤 4：近期信号汇总**
```bash
curl -s "https://api.ctmon.xyz/signals/recent?hours=6" \
  -H "Authorization: Bearer $CT_MONITOR_API_KEY" | jq '.'
```

**整合提示词**：
> 以上是本周市场数据（AI 简报 + 趋势币 + 价格总览 + 信号），请生成周度投资决策报告：① 市场趋势判断（牛/熊/震荡）② 值得关注的赛道 ③ 主流币配置建议 ④ 风险提示 ⑤ 定投策略建议

---

### 单一 API 快速参考

| 操作 | 命令 |
| :--- | :--- |
| 市场推文流 | `GET /tweets/feed?limit=50` |
| KOL 历史推文 | `GET /tweets/recent?username=XXX&limit=20` |
| KOL 实时推文 | `GET /twitter/realtime?username=XXX&limit=10` |
| 关键词搜索 | `GET /tweets/search?keyword=airdrop&limit=20` |
| 统一资讯流 | `GET /info/feed?limit=30&min_score=0.5` |
| 代币价格 | `GET /price/token?symbol=BTC` |
| 趋势币 | `GET /price/trending?hours=6` |
| 市场总览 | `GET /price/summary` |
| Alpha 信号 | `GET /signals/recent?hours=6&min_score=60` |
| AI 简报 | `GET /brief/generate?hours=24` |
| KOL 排行 | `GET /users/top?limit=10` |
| 添加监控 | `POST /subscriptions/?username=pump_fun` |
| 删除监控 | `DELETE /subscriptions/pump_fun` |
| 系统状态 | `GET /status/sync` |

## OpenClaw Cron 定时推送示例

**每小时快讯**：
```yaml
schedule: "0 * * * *"
task: |
  调用 GET /brief/generate?hours=1 获取最近 1 小时 AI 简报，
  用中文整理成 5 条要点，通过 Telegram 发送给我。
```

**每日综合简报**：
```yaml
schedule: "0 8 * * *"
task: |
  1. 调用 GET /brief/generate?hours=24 获取 24 小时 AI 简报
  2. 调用 GET /price/trending?hours=24 获取趋势币分析
  3. 调用 GET /signals/recent?hours=6 获取最新信号
  整合以上数据，生成一份完整的每日加密市场简报，发送到 Telegram。
```

**实时信号监控**：
```yaml
schedule: "*/15 * * * *"
task: |
  调用 GET /signals/recent?hours=0.25 获取最近 15 分钟信号，
  若有 kol_count >= 3 的信号，立即发送 Telegram 预警。
```

## Pricing Reference

| 端点 | 费用 | 说明 |
| :--- | :--- | :--- |
| `/signals/recent` hours<2 | 3¢ | 6551 实时数据 |
| `/signals/recent` hours≥2 | 1¢ | 内部历史数据库 |
| `/twitter/realtime` | 2¢ | 6551 实时推文 |
| `/brief/generate` hours=1 | 6¢ | 1H 快讯（Grok 4.1 Fast） |
| `/brief/generate` hours=8 | 4¢ | 8H 简报 |
| `/brief/generate` hours=12/24 | 2¢ | 12/24H 简报 |
| `/info/feed` | 1¢ | 统一资讯流 |
| `/price/token` | 1¢ | 代币价格查询 |
| `/price/trending` | 1¢ | 趋势币分析 |
| `/price/summary` | 1¢ | 市场总览 |

## Error Handling

- API 返回 `[]`：告知"暂无数据，数据同步可能仍在进行中"
- API 返回 `401`：API Key 无效，检查 `$CT_MONITOR_API_KEY` 环境变量
- API 返回 `402`：余额不足，需要充值
- API 返回 `404`：用户不在监控列表，建议先添加订阅
- 网络超时：重试一次，若仍失败告知用户稍后再试
