# Strategic Planning

## Planning Horizons

| Horizon | Timeframe | Focus |
|---------|-----------|-------|
| **H1** | 0-12 months | Execute current strategy, optimize operations |
| **H2** | 12-36 months | Build emerging opportunities, scale winners |
| **H3** | 36+ months | Explore future bets, R&D investments |

## Annual Planning Cycle

**Q4: Strategy Review**
- Assess prior year performance
- Update market and competitive analysis
- Draft strategic themes for next year

**Q1: Planning**
- Finalize strategic priorities (3-5 max)
- Cascade OKRs to departments
- Allocate resources to initiatives

**Q2-Q3: Execution + Mid-year Review**
- Track leading indicators
- Adjust tactics, hold strategy
- Kill underperformers early

## Strategic Planning Frameworks

### Vision → Strategy → Execution Cascade
```
Vision (10 years)
  └── Mission (why we exist)
      └── Strategic Pillars (3-5 themes)
          └── Annual Goals (measurable)
              └── Quarterly OKRs (team level)
                  └── Weekly priorities (individual)
```

### Playing to Win (Lafley/Martin)
1. **What is our winning aspiration?**
2. **Where will we play?** (markets, segments, geographies)
3. **How will we win?** (differentiation, cost leadership)
4. **What capabilities must we have?**
5. **What management systems are needed?**

### Strategy on a Page Template
```
WINNING ASPIRATION: [1 sentence goal]

WHERE WE PLAY          | HOW WE WIN
- Market:              | - Differentiation:
- Customer segment:    | - Competitive moat:
- Geography:           | - Pricing approach:

MUST-HAVE CAPABILITIES | REQUIRED SYSTEMS
- Capability 1         | - Process 1
- Capability 2         | - Technology 1
- Capability 3         | - Metrics/governance
```

## OKR Framework

**Objective:** Qualitative, inspiring, time-bound
**Key Results:** Quantitative, measurable, ambitious

```
Objective: Become the market leader in X
  KR1: Reach $10M ARR (currently $4M)
  KR2: Achieve 50% market share in target segment
  KR3: Net Promoter Score > 60
```

**Scoring:**
- 0.0-0.3 = Red (failed)
- 0.4-0.6 = Yellow (progress)
- 0.7-1.0 = Green (achieved)

**Common OKR Mistakes:**
- Too many objectives (max 3-5)
- Key results that are tasks, not outcomes
- No connection between team and company OKRs
- Setting sandbagged targets

## Strategy Review Template

| Question | Assessment |
|----------|------------|
| Is market thesis still valid? | |
| Are we winning vs competitors? | |
| Are key assumptions holding? | |
| What's changed since last review? | |
| What should we start/stop/continue? | |
